/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.gui;

import edu.colorado.phet.batteryresistorcircuit.common.math.functions.Transform;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;
import java.awt.Color;
import java.awt.Image;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VoltageSlider
extends JPanel
implements ChangeListener {
    Transform transform;
    JSlider js;
    JTextField jtf;
    String name;
    Vector listeners = new Vector();
    NumberFormat nf;
    String units;

    public VoltageSlider(Transform transform, String string, Image image, double d, NumberFormat numberFormat, String string2) {
        this.nf = numberFormat;
        this.units = string2;
        this.name = string;
        this.transform = transform;
        this.jtf = new JTextField();
        this.jtf.setEditable(false);
        double d2 = transform.invert().evaluate(d);
        int n = (int)transform.getDomainMin();
        int n2 = (int)transform.getDomainMax();
        int n3 = (int)d2;
        int n4 = n2 - n;
        this.js = new JSlider(n, n2, n3);
        this.js.setPaintTicks(true);
        this.js.setMajorTickSpacing(n4 / 10);
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(string, new ImageIcon(image), 11);
        this.add(jLabel);
        this.add(this.js);
        this.add(this.jtf);
        this.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.js.addChangeListener(this);
        this.fireChange();
    }

    public void addVoltageListener(VoltageListener voltageListener) {
        this.listeners.add(voltageListener);
    }

    public void fireChange() {
        double d = this.transform.evaluate(this.js.getValue());
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((VoltageListener)this.listeners.get(i)).valueChanged(d);
        }
        this.jtf.setText(this.name + " = " + this.nf.format(d) + " " + this.units);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }
}

