/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.gui;

import edu.colorado.phet.batteryresistorcircuit.gui.CoreCountListener;
import java.awt.Color;
import java.awt.Image;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CoreCountSlider
extends JPanel
implements ChangeListener {
    JSlider js;
    JTextField jtf;
    String name;
    String units;
    Vector listeners = new Vector();
    static final NumberFormat nf = new DecimalFormat("##.##");

    public CoreCountSlider(int n, int n2, int n3, String string, Image image, String string2) {
        JLabel jLabel = new JLabel(string, new ImageIcon(image), 11);
        this.name = string;
        this.units = string2;
        this.jtf = new JTextField();
        this.jtf.setEditable(false);
        this.js = new JSlider(n, n2, n3);
        this.js.setPaintTicks(true);
        int n4 = n2 - n;
        this.js.setMajorTickSpacing(n4 / 10);
        this.setLayout(new BoxLayout(this, 1));
        this.add(jLabel);
        this.add(this.js);
        this.add(this.jtf);
        this.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.js.addChangeListener(this);
        this.fireChange();
    }

    public void addIntListener(CoreCountListener coreCountListener) {
        this.listeners.add(coreCountListener);
    }

    public void fireChange() {
        int n = this.js.getValue();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((CoreCountListener)this.listeners.get(i)).coreCountChanged(n);
        }
        double d = (double)n * 0.2 / 3.0;
        this.jtf.setText(this.name + " = " + nf.format(d) + " " + this.units);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }
}

