/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.common.wire1d.forces;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;

public class CoulombForceParameters {
    double k;
    double power;
    double minDist;
    double maxDist;

    public CoulombForceParameters(double d, double d2) {
        this.k = d;
        this.power = d2;
        this.maxDist = Double.POSITIVE_INFINITY;
    }

    public double getForce(WireParticle wireParticle, WireParticle wireParticle2) {
        return this.getForce(wireParticle.getPosition(), wireParticle.getCharge(), wireParticle2.getPosition(), wireParticle2.getCharge());
    }

    public double getForce(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = Math.abs(d5);
        if (d6 < this.minDist) {
            d6 = this.minDist;
        } else if (d6 > this.maxDist) {
            d6 = this.maxDist;
        }
        double d7 = this.k * Math.pow(d6, this.power) * d2 * d4;
        if (d5 > 0.0) {
            d7 *= -1.0;
        }
        return d7;
    }

    public void setMinDistance(double d) {
        this.minDist = d;
    }
}

