/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.common.wire1d;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WirePatch;
import java.util.Vector;

public class Circuit {
    Vector patches = new Vector();

    public void addWirePatch(WirePatch wirePatch) {
        this.patches.add(wirePatch);
    }

    public WirePatch getPatch(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.patches.size(); ++i) {
            if (!(d <= (d2 += this.patchAt(i).totalDistance()))) continue;
            return this.patchAt(i);
        }
        throw new RuntimeException("Patch not found for position=" + d + ", length=" + this.getLength());
    }

    public double getLocalPosition(double d, WirePatch wirePatch) {
        double d2 = 0.0;
        for (int i = 0; i < this.patches.size(); ++i) {
            if (this.patchAt(i) == wirePatch) {
                return d - d2;
            }
            d2 += this.patchAt(i).totalDistance();
        }
        throw new RuntimeException("Patch not found.");
    }

    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.patches.size(); ++i) {
            d += this.patchAt(i).totalDistance();
        }
        return d;
    }

    public WirePatch patchAt(int n) {
        return (WirePatch)this.patches.get(n);
    }
}

