/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.common.paint.particle;

import edu.colorado.phet.batteryresistorcircuit.common.paint.particle.ParticlePainter;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Particle;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImagePainter
implements ParticlePainter {
    BufferedImage im;

    public ImagePainter(BufferedImage bufferedImage) {
        this.im = bufferedImage;
        if (bufferedImage == null) {
            throw new RuntimeException("ImagePainter created with null image.");
        }
    }

    public void paint(Particle particle, Graphics2D graphics2D) {
        DoublePoint doublePoint = particle.getPosition();
        if (this.im == null) {
            throw new RuntimeException("Null painter.");
        }
        if (doublePoint == null) {
            throw new RuntimeException("Particle has null position.");
        }
        int n = (int)doublePoint.getX() - this.im.getWidth() / 2;
        int n2 = (int)doublePoint.getY() - this.im.getHeight() / 2;
        graphics2D.drawRenderedImage(this.im, AffineTransform.getTranslateInstance(n, n2));
    }
}

