/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.collisions;

import edu.colorado.phet.batteryresistorcircuit.Electron;
import edu.colorado.phet.batteryresistorcircuit.collisions.CollisionEvent;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Law;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.System2D;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Core;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Oscillate;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.OscillateFactory;

public class DefaultCollisionEvent
implements CollisionEvent,
Law {
    double distThreshold;
    double amplitudeThreshold;
    OscillateFactory of;
    double velocityToZero = Double.POSITIVE_INFINITY;
    double time;

    public DefaultCollisionEvent(double d, double d2, OscillateFactory oscillateFactory) {
        this.of = oscillateFactory;
        this.distThreshold = d;
        this.amplitudeThreshold = d2;
    }

    public void iterate(double d, System2D system2D) {
        this.time += d;
    }

    public void collide(Core core, Electron electron) {
        double d = core.getScalarPosition() - electron.getPosition();
        Oscillate oscillate = (Oscillate)core.getPropagator();
        double d2 = electron.getVelocity();
        if (Math.abs(d) < this.distThreshold) {
            if (oscillate.getAmplitude() < this.amplitudeThreshold) {
                if (electron.getLastCollision() != core) {
                    Oscillate oscillate2 = this.of.newOscillate(d2, core);
                    core.setPropagator(oscillate2);
                    electron.setCollided(true);
                    electron.setLastCollision(core, this.time);
                }
            } else if (d2 >= this.velocityToZero) {
                electron.setCollided(true);
            }
        }
    }

    public double currentTime() {
        return this.time;
    }
}

