/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit;

import edu.colorado.phet.batteryresistorcircuit.collisions.DefaultCollisionEvent;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WirePatch;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.propagators.CompositePropagator1d;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Core;

public class Electron
extends WireParticle {
    boolean collided = false;
    Core last;
    double time = Double.NaN;
    DefaultCollisionEvent dce;

    public Electron(CompositePropagator1d compositePropagator1d, WirePatch wirePatch, DefaultCollisionEvent defaultCollisionEvent) {
        super(compositePropagator1d, wirePatch);
        this.dce = defaultCollisionEvent;
    }

    public void forgetCollision() {
        this.last = null;
        this.time = Double.NaN;
        this.collided = false;
    }

    public Core getLastCollision() {
        if (this.dce == null) {
            return null;
        }
        if (this.dce.currentTime() - this.time > 20.0) {
            this.setCollided(false);
        }
        return this.last;
    }

    public void setVelocity(double d) {
        super.setVelocity(d);
    }

    public void setLastCollision(Core core, double d) {
        this.last = core;
        this.time = d;
    }

    public void setCollided(boolean bl) {
        this.collided = bl;
    }

    public boolean isCollided() {
        return this.collided;
    }
}

