/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit;

import edu.colorado.phet.batteryresistorcircuit.common.paint.Painter;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WirePatch;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireSystem;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;
import edu.colorado.phet.batteryresistorcircuit.volt.WireRegion;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;

public class AngelPaint
implements Painter,
VoltageListener {
    double v;
    WireRegion region;
    BufferedImage left;
    BufferedImage right;
    WireSystem ws;
    WirePatch converter;
    Point dx;
    JCheckBox jcb;
    Point dx2;

    public AngelPaint(WireRegion wireRegion, BufferedImage bufferedImage, BufferedImage bufferedImage2, WireSystem wireSystem, WirePatch wirePatch, Point point, Point point2, JCheckBox jCheckBox) {
        this.dx2 = point2;
        this.jcb = jCheckBox;
        this.dx = point;
        this.converter = wirePatch;
        this.ws = wireSystem;
        this.region = wireRegion;
        this.left = bufferedImage;
        this.right = bufferedImage2;
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.jcb.isSelected()) {
            return;
        }
        for (int i = 0; i < this.ws.numParticles(); ++i) {
            AffineTransform affineTransform;
            WireParticle wireParticle = this.ws.particleAt(i);
            if (!this.region.contains(wireParticle)) continue;
            DoublePoint doublePoint = this.converter.getPosition(wireParticle.getPosition());
            if (this.v > 0.0) {
                affineTransform = AffineTransform.getTranslateInstance(doublePoint.getX() + (double)this.dx.x, doublePoint.getY() + (double)this.dx.y);
                graphics2D.drawRenderedImage(this.right, affineTransform);
                continue;
            }
            if (!(this.v < 0.0)) continue;
            affineTransform = AffineTransform.getTranslateInstance(doublePoint.getX() + (double)this.dx2.x, doublePoint.getY() + (double)this.dx2.y);
            graphics2D.drawRenderedImage(this.left, affineTransform);
        }
    }

    public void valueChanged(double d) {
        this.v = d;
    }
}

