/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.BalloonForces;
import edu.colorado.phet.balloons.BalloonPainter;
import edu.colorado.phet.balloons.Charge;
import edu.colorado.phet.balloons.Dipole;
import edu.colorado.phet.balloons.common.paint.Painter;
import edu.colorado.phet.balloons.common.paint.ParticlePainter;
import edu.colorado.phet.balloons.common.phys2d.DoublePoint;
import edu.colorado.phet.balloons.common.phys2d.Law;
import edu.colorado.phet.balloons.common.phys2d.System2D;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JCheckBox;

public class Wall
implements Painter,
Law {
    JCheckBox show;
    Rectangle bounds;
    Painter background;
    Vector d = new Vector();
    BalloonPainter blu;
    BalloonPainter yel;
    int w;
    int h;
    public static final DoublePoint ZERO = new DoublePoint();

    public void iterate(double d, System2D system2D) {
        Point point = this.blu.getPosition();
        Point point2 = this.yel.getPosition();
        DoublePoint doublePoint = new DoublePoint(point.x + this.w / 2, point.y + this.h / 2);
        boolean bl = this.blu.isVisible();
        DoublePoint doublePoint2 = new DoublePoint(point2.x + this.w / 2, point2.y + this.h / 2);
        boolean bl2 = this.yel.isVisible();
        double d2 = 1.0;
        for (int i = 0; i < this.d.size(); ++i) {
            Dipole dipole = (Dipole)this.d.get(i);
            Charge charge = dipole.p();
            Charge charge2 = dipole.m();
            DoublePoint doublePoint3 = this.getForce(charge2, bl, doublePoint, this.blu.getCharge()).add(this.getForce(charge2, bl2, doublePoint2, this.yel.getCharge()));
            DoublePoint doublePoint4 = charge2.getInitialPosition().add(doublePoint3);
            if (doublePoint4.getX() < (double)this.bounds.x) {
                doublePoint4 = new DoublePoint(this.bounds.x, doublePoint4.getY());
            }
            charge2.setPosition(doublePoint4);
        }
    }

    public DoublePoint getForce(Charge charge, boolean bl, DoublePoint doublePoint, int n) {
        if (!bl) {
            return ZERO;
        }
        double d = -200000.0;
        double d2 = d * charge.getCharge() * (double)n;
        DoublePoint doublePoint2 = BalloonForces.getForce(charge.getPosition(), doublePoint, d2, 2.7);
        if (doublePoint2.length() <= 2.0) {
            return ZERO;
        }
        if (doublePoint2.length() > 40.0) {
            return doublePoint2.normalize().multiply(40.0);
        }
        return doublePoint2;
    }

    public boolean isVisible() {
        return this.show.isSelected();
    }

    public Wall(JCheckBox jCheckBox, Rectangle rectangle, Painter painter, ParticlePainter particlePainter, ParticlePainter particlePainter2, BalloonPainter balloonPainter, BalloonPainter balloonPainter2) {
        this.w = balloonPainter.getImage().getWidth();
        this.h = balloonPainter.getImage().getHeight();
        this.blu = balloonPainter;
        this.yel = balloonPainter2;
        this.show = jCheckBox;
        this.bounds = rectangle;
        this.background = painter;
        int n = 3;
        int n2 = 18;
        int n3 = rectangle.width / n + 4;
        int n4 = rectangle.height / n2;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                n5 = i % 2 == 0 ? n4 / 2 : 0;
                int n6 = i * n3 + rectangle.x;
                int n7 = j * n4 + rectangle.y + n5;
                Dipole dipole = new Dipole(n6, n7, n6, n7, particlePainter, particlePainter2);
                this.d.add(dipole);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.show.isSelected()) {
            return;
        }
        this.background.paint(graphics2D);
        for (int i = 0; i < this.d.size(); ++i) {
            ((Painter)this.d.get(i)).paint(graphics2D);
        }
    }
}

