/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.BalloonPainter;
import edu.colorado.phet.balloons.Sweater;
import edu.colorado.phet.balloons.Wall;
import edu.colorado.phet.balloons.common.paint.FixedImagePainter;
import edu.colorado.phet.balloons.common.phys2d.DoublePoint;
import edu.colorado.phet.balloons.common.phys2d.Law;
import edu.colorado.phet.balloons.common.phys2d.System2D;
import java.awt.Point;
import java.awt.Rectangle;

public class BalloonForces
implements Law {
    BalloonPainter a;
    BalloonPainter b;
    Sweater s;
    Rectangle bounds;
    int w2;
    int h2;
    int wallX;
    Wall wall;
    double k = 10.0;

    public BalloonForces(BalloonPainter balloonPainter, BalloonPainter balloonPainter2, Sweater sweater, Rectangle rectangle, int n, Wall wall) {
        this.wall = wall;
        this.wallX = n;
        this.bounds = rectangle;
        this.a = balloonPainter;
        this.b = balloonPainter2;
        this.s = sweater;
        this.w2 = balloonPainter.getFixedPainter().getImage().getWidth() / 2;
        this.h2 = balloonPainter.getFixedPainter().getImage().getHeight() / 2;
    }

    public DoublePoint getCenter(BalloonPainter balloonPainter) {
        FixedImagePainter fixedImagePainter = balloonPainter.getFixedPainter();
        Point point = balloonPainter.getPosition();
        DoublePoint doublePoint = new DoublePoint(point.x + this.w2, point.y + this.h2);
        return doublePoint;
    }

    public void iterate(double d, System2D system2D) {
        DoublePoint doublePoint;
        if (this.a.isVisible() && !this.a.isHeld()) {
            doublePoint = this.getForce(this.a, this.b);
            this.applyForce(d, doublePoint, this.a);
        }
        if (this.b.isVisible() && !this.b.isHeld()) {
            doublePoint = this.getForce(this.b, this.a);
            this.applyForce(d, doublePoint, this.b);
        }
    }

    public DoublePoint getForce(BalloonPainter balloonPainter, BalloonPainter balloonPainter2) {
        DoublePoint doublePoint = this.getSweaterForce(balloonPainter);
        DoublePoint doublePoint2 = this.getOtherForce(balloonPainter, balloonPainter2);
        if (this.wall.isVisible()) {
            double d = (double)this.wallX - balloonPainter.getPosition().getX();
            double d2 = balloonPainter.getCharge();
            if (d2 > 5.0) {
                double d3 = d - 140.0;
                double d4 = 0.3;
                if (d3 <= 20.0 + d2 / 8.0) {
                    return new DoublePoint(d4 * d2 / 20.0, 0.0);
                }
            }
        }
        return doublePoint.add(doublePoint2);
    }

    public DoublePoint getSweaterForce(BalloonPainter balloonPainter) {
        DoublePoint doublePoint = this.s.getCenter();
        DoublePoint doublePoint2 = this.getCenter(balloonPainter);
        double d = this.a.getCharge() + this.b.getCharge();
        double d2 = balloonPainter.getCharge();
        return BalloonForces.getForce(doublePoint, doublePoint2, this.k * d * d2);
    }

    public static DoublePoint getForce(DoublePoint doublePoint, DoublePoint doublePoint2, double d) {
        DoublePoint doublePoint3 = doublePoint.subtract(doublePoint2);
        double d2 = doublePoint3.length();
        if (d2 == 0.0) {
            return new DoublePoint();
        }
        DoublePoint doublePoint4 = doublePoint3.multiply(d / (d2 * d2 * d2));
        return doublePoint4;
    }

    public static DoublePoint getForce(DoublePoint doublePoint, DoublePoint doublePoint2, double d, double d2) {
        DoublePoint doublePoint3 = doublePoint.subtract(doublePoint2);
        double d3 = doublePoint3.length();
        if (d3 == 0.0) {
            return new DoublePoint();
        }
        DoublePoint doublePoint4 = doublePoint3.multiply(d / Math.pow(d3, d2 + 1.0));
        return doublePoint4;
    }

    public DoublePoint getOtherForce(BalloonPainter balloonPainter, BalloonPainter balloonPainter2) {
        if (balloonPainter.isHeld() || !balloonPainter.isVisible() || !balloonPainter2.isVisible()) {
            return new DoublePoint();
        }
        double d = this.k * (double)balloonPainter.getCharge() * (double)balloonPainter2.getCharge();
        DoublePoint doublePoint = this.getCenter(balloonPainter);
        DoublePoint doublePoint2 = this.getCenter(balloonPainter2);
        return BalloonForces.getForce(doublePoint, doublePoint2, d);
    }

    public void applyForce(double d, DoublePoint doublePoint, BalloonPainter balloonPainter) {
        DoublePoint doublePoint2 = balloonPainter.getVelocity();
        DoublePoint doublePoint3 = doublePoint2.add(doublePoint.multiply(d));
        Point point = balloonPainter.getPosition();
        DoublePoint doublePoint4 = new DoublePoint(point.x, point.y);
        DoublePoint doublePoint5 = doublePoint4.add(doublePoint3.multiply(d));
        Point point2 = new Point((int)doublePoint5.getX(), (int)doublePoint5.getY());
        Point point3 = new Point(point2.x + this.w2 * 2, point2.y + this.h2 * 2);
        if (this.bounds.contains(point2) && this.bounds.contains(point3) || !this.wall.isVisible() && point3.x > 300) {
            balloonPainter.setVelocity(doublePoint3);
            balloonPainter.getFixedPainter().setPosition(point2);
        } else {
            balloonPainter.setVelocity(new DoublePoint());
        }
    }
}

