/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.BalloonDragListener;
import edu.colorado.phet.balloons.BalloonPainter;
import edu.colorado.phet.balloons.Wall;
import edu.colorado.phet.balloons.common.paint.Painter;
import edu.colorado.phet.balloons.common.phys2d.DoublePoint;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class BalloonDragger
implements Painter,
MouseListener,
MouseMotionListener {
    BalloonPainter[] p;
    Component paintMe;
    Point balloonStart;
    Point mouseStart;
    BalloonPainter sel;
    Vector list = new Vector();
    Rectangle bounds;
    Wall wall;

    public void addBalloonDragListener(BalloonDragListener balloonDragListener) {
        this.list.add(balloonDragListener);
    }

    public BalloonDragger(BalloonPainter[] balloonPainterArray, Component component, Rectangle rectangle, Wall wall) {
        this.bounds = rectangle;
        this.p = balloonPainterArray;
        this.paintMe = component;
        if (wall == null) {
            throw new IllegalArgumentException();
        }
        this.wall = wall;
    }

    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.p.length; ++i) {
            if (this.sel == this.p[i]) continue;
            this.p[i].paint(graphics2D);
        }
        if (this.sel != null) {
            this.sel.paint(graphics2D);
        }
    }

    public static Point getInsideBounds(Point point, Rectangle rectangle, Wall wall) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (!wall.isVisible()) {
            n3 = wall.w / 2;
        }
        n = point.x > rectangle.x + rectangle.width + n3 ? rectangle.x + rectangle.width + n3 : (point.x < rectangle.x ? rectangle.x : point.x);
        n2 = point.y > rectangle.y + rectangle.height ? rectangle.y + rectangle.height : (point.y < rectangle.y ? rectangle.y : point.y);
        return new Point(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseStart == null) {
            return;
        }
        Component component = this.paintMe;
        synchronized (component) {
            Point point = mouseEvent.getPoint();
            Point point2 = new Point(point.x - this.mouseStart.x, point.y - this.mouseStart.y);
            Point point3 = new Point(this.balloonStart.x + point2.x, this.balloonStart.y + point2.y);
            point3 = BalloonDragger.getInsideBounds(point3, this.bounds, this.wall);
            this.sel.getFixedPainter().setPosition(point3);
            this.sel.setIsHeld(true);
            for (int i = 0; i < this.list.size(); ++i) {
                ((BalloonDragListener)this.list.get(i)).balloonDragged(this.sel);
            }
            this.paintMe.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        BalloonPainter balloonPainter = this.sel;
        this.sel = this.getHit(mouseEvent.getPoint());
        if (this.sel == null) {
            return;
        }
        this.sel.setIsHeld(true);
        if (balloonPainter != null) {
            balloonPainter.setIsHeld(false);
        }
        this.balloonStart = this.sel.getFixedPainter().getPosition();
        this.mouseStart = mouseEvent.getPoint();
        this.paintMe.repaint();
    }

    private BalloonPainter getHit(Point point) {
        if (this.sel != null && this.isHit(point, this.sel)) {
            return this.sel;
        }
        for (int i = 0; i < this.p.length; ++i) {
            if (!this.isHit(point, this.p[i])) continue;
            return this.p[i];
        }
        return null;
    }

    public boolean isHit(Point point, BalloonPainter balloonPainter) {
        BufferedImage bufferedImage = balloonPainter.getFixedPainter().getImage();
        Point point2 = balloonPainter.getFixedPainter().getPosition();
        Rectangle rectangle = new Rectangle(point2.x, point2.y, bufferedImage.getWidth(), bufferedImage.getHeight());
        return rectangle.contains(point) && balloonPainter.isVisible();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseStart = null;
        if (this.sel != null) {
            this.sel.setIsHeld(false);
            this.sel.setVelocity(new DoublePoint());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getHit(mouseEvent.getPoint()) != null) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

