/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.util;

import edu.umd.cs.piccolo.PNode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNodeLayoutUtils {
    public static double getOriginXOffset(PNode pNode) {
        return pNode.getFullBoundsReference().getX() - pNode.getXOffset();
    }

    public static double getOriginYOffset(PNode pNode) {
        return pNode.getFullBoundsReference().getY() - pNode.getYOffset();
    }

    public static double getMaxFullWidthChildren(PNode pNode) {
        return PNodeLayoutUtils.getMaxFullWidth(pNode.getChildrenReference());
    }

    public static double getMaxFullWidth(List<PNode> list) {
        double d = 0.0;
        for (PNode pNode : list) {
            double d2 = pNode.getFullBoundsReference().getWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double sumFullHeightsChildren(PNode pNode) {
        return PNodeLayoutUtils.sumFullHeights(pNode.getChildrenReference());
    }

    public static double sumFullHeights(List<PNode> list) {
        double d = 0.0;
        for (PNode pNode : list) {
            d += pNode.getFullBoundsReference().getHeight();
        }
        return d;
    }

    public static void alignInside(PNode pNode, PNode pNode2, int n, int n2, double d, double d2) {
        double d3 = 0.0;
        switch (n2) {
            case 2: {
                d3 = pNode2.getFullBoundsReference().getMinX() + d;
                break;
            }
            case 0: {
                d3 = pNode2.getFullBoundsReference().getCenterX() - pNode.getFullBoundsReference().getWidth() / 2.0;
                break;
            }
            case 4: {
                d3 = pNode2.getFullBoundsReference().getMaxX() - pNode.getFullBoundsReference().getWidth() - d;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal value for horizontalAlignment: " + n2);
            }
        }
        double d4 = 0.0;
        switch (n) {
            case 1: {
                d4 = pNode2.getFullBoundsReference().getMinY() + d2;
                break;
            }
            case 0: {
                d4 = pNode2.getFullBoundsReference().getCenterY() - pNode.getFullBoundsReference().getHeight() / 2.0;
                break;
            }
            case 3: {
                d4 = pNode2.getFullBoundsReference().getMaxY() - pNode.getFullBoundsReference().getHeight() - d2;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal value for verticalAlignment: " + n);
            }
        }
        pNode.setOffset(d3 - PNodeLayoutUtils.getOriginXOffset(pNode), d4 - PNodeLayoutUtils.getOriginYOffset(pNode));
    }

    public static void alignInside(PNode pNode, PNode pNode2, int n, int n2) {
        PNodeLayoutUtils.alignInside(pNode, pNode2, n, n2, 0.0, 0.0);
    }
}

