/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing.components;

import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterValue;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserAction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterValues;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;

public class SimSharingJSpinner
extends JSpinner {
    private final IUserComponent userComponent;
    private boolean buttonPressed;
    private boolean enterPressed;
    private boolean focusLost;
    private boolean upPressed;
    private boolean downPressed;
    private KeyListener keyListener;
    private FocusListener focusListener;

    public SimSharingJSpinner(IUserComponent iUserComponent) {
        this.userComponent = iUserComponent;
        this.init();
    }

    private void init() {
        this.initListeners();
        this.enableMouseEvents();
    }

    private void initListeners() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SimSharingJSpinner.this.buttonPressed = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SimSharingJSpinner.this.buttonPressed = false;
            }
        };
        for (Component component : this.getComponents()) {
            if (!(component instanceof JButton)) continue;
            ((JButton)component).addMouseListener(mouseAdapter);
        }
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SimSharingJSpinner.this.enterPressed = true;
                } else if (keyEvent.getKeyCode() == 38) {
                    SimSharingJSpinner.this.upPressed = true;
                } else if (keyEvent.getKeyCode() == 40) {
                    SimSharingJSpinner.this.downPressed = true;
                }
            }
        };
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SimSharingJSpinner.this.focusLost = true;
            }
        };
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            jFormattedTextField.addKeyListener(this.keyListener);
            jFormattedTextField.addFocusListener(this.focusListener);
        }
    }

    public void setEnabled(boolean bl) {
        this.focusLost = this.focusLost && bl;
        super.setEnabled(bl);
    }

    public void setEditor(JComponent jComponent) {
        JFormattedTextField jFormattedTextField;
        JComponent jComponent2 = this.getEditor();
        if (jComponent2 instanceof JSpinner.DefaultEditor) {
            jFormattedTextField = ((JSpinner.DefaultEditor)jComponent2).getTextField();
            jFormattedTextField.removeKeyListener(this.keyListener);
            jFormattedTextField.removeFocusListener(this.focusListener);
        }
        if (jComponent instanceof JSpinner.DefaultEditor) {
            jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            jFormattedTextField.addKeyListener(this.keyListener);
            jFormattedTextField.addFocusListener(this.focusListener);
        }
        super.setEditor(jComponent);
    }

    private void enableMouseEvents() {
        this.enableEvents(16L);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && !this.isEnabled()) {
            this.sendMessage(UserActions.mousePressed, this.getCommonParameters().with((IParameterKey)ParameterKeys.enabled, this.isEnabled()).with((IParameterKey)ParameterKeys.interactive, this.isEnabled()));
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void fireStateChanged() {
        if (this.buttonPressed) {
            this.sendMessage(UserActions.buttonPressed);
        } else if (this.enterPressed) {
            this.sendTextFieldCommittedMessage(ParameterValues.enterKey);
            this.enterPressed = false;
        } else if (this.focusLost) {
            this.sendTextFieldCommittedMessage(ParameterValues.focusLost);
            this.focusLost = false;
        } else if (this.upPressed) {
            this.sendTextFieldCommittedMessage(ParameterValues.upKey);
            this.upPressed = false;
        } else if (this.downPressed) {
            this.sendTextFieldCommittedMessage(ParameterValues.downKey);
            this.downPressed = false;
        }
        super.fireStateChanged();
    }

    private void sendTextFieldCommittedMessage(IParameterValue iParameterValue) {
        this.sendMessage(UserActions.textFieldCommitted, ParameterSet.parameterSet((IParameterKey)ParameterKeys.commitAction, iParameterValue).with(this.getCommonParameters()));
    }

    protected ParameterSet getCommonParameters() {
        return ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, this.getValue().toString());
    }

    protected void sendMessage(IUserAction iUserAction) {
        this.sendMessage(iUserAction, this.getCommonParameters());
    }

    protected void sendMessage(IUserAction iUserAction, ParameterSet parameterSet) {
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.spinner, iUserAction, parameterSet);
    }
}

