/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view.game;

import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.chemistry.molecules.AtomNode;
import edu.colorado.phet.chemistry.molecules.C2H2Node;
import edu.colorado.phet.chemistry.molecules.C2H4Node;
import edu.colorado.phet.chemistry.molecules.C2H5ClNode;
import edu.colorado.phet.chemistry.molecules.C2H5OHNode;
import edu.colorado.phet.chemistry.molecules.C2H6Node;
import edu.colorado.phet.chemistry.molecules.CH2ONode;
import edu.colorado.phet.chemistry.molecules.CH3OHNode;
import edu.colorado.phet.chemistry.molecules.CH4Node;
import edu.colorado.phet.chemistry.molecules.H2ONode;
import edu.colorado.phet.chemistry.molecules.H2SNode;
import edu.colorado.phet.chemistry.molecules.HClNode;
import edu.colorado.phet.chemistry.molecules.HFNode;
import edu.colorado.phet.chemistry.molecules.HorizontalMoleculeNode;
import edu.colorado.phet.chemistry.molecules.NH3Node;
import edu.colorado.phet.chemistry.molecules.NO2Node;
import edu.colorado.phet.chemistry.molecules.OF2Node;
import edu.colorado.phet.chemistry.molecules.P4Node;
import edu.colorado.phet.chemistry.molecules.PCl3Node;
import edu.colorado.phet.chemistry.molecules.PCl5Node;
import edu.colorado.phet.chemistry.molecules.PF3Node;
import edu.colorado.phet.chemistry.molecules.SO2Node;
import edu.colorado.phet.chemistry.molecules.SO3Node;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class GameRewardNode
extends PhetPNode {
    private final ConstantDtClock clock;
    private final Image faceImage;
    private final ArrayList<Image> atomImages;
    private final ArrayList<Image> moleculeImages;
    private final ArrayList<Image> imagePool;
    private int population;
    private int motionDelta;
    private IMotionStrategy motionStrategy;

    public GameRewardNode() {
        this(new PBounds(0.0, 0.0, 100.0, 100.0), 100, 5);
    }

    public GameRewardNode(PBounds pBounds, int n, int n2) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.population = n;
        this.motionDelta = n2;
        this.motionStrategy = new FallingMotionStrategy();
        this.clock = new ConstantDtClock(60, 1.0);
        this.clock.pause();
        this.atomImages = new ArrayList();
        this.atomImages.add(new AtomNode(Element.C).toImage());
        this.atomImages.add(new AtomNode(Element.Cl).toImage());
        this.atomImages.add(new AtomNode(Element.F).toImage());
        this.atomImages.add(new AtomNode(Element.H).toImage());
        this.atomImages.add(new AtomNode(Element.N).toImage());
        this.atomImages.add(new AtomNode(Element.O).toImage());
        this.atomImages.add(new AtomNode(Element.P).toImage());
        this.atomImages.add(new AtomNode(Element.S).toImage());
        this.moleculeImages = new ArrayList();
        this.moleculeImages.add(new HorizontalMoleculeNode.CNode().toImage());
        this.moleculeImages.add(new C2H2Node().toImage());
        this.moleculeImages.add(new C2H4Node().toImage());
        this.moleculeImages.add(new C2H5ClNode().toImage());
        this.moleculeImages.add(new C2H5OHNode().toImage());
        this.moleculeImages.add(new C2H6Node().toImage());
        this.moleculeImages.add(new CH2ONode().toImage());
        this.moleculeImages.add(new CH3OHNode().toImage());
        this.moleculeImages.add(new CH4Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.Cl2Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.CONode().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.CO2Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.CS2Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.F2Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.CONode().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.H2Node().toImage());
        this.moleculeImages.add(new H2ONode().toImage());
        this.moleculeImages.add(new H2SNode().toImage());
        this.moleculeImages.add(new HClNode().toImage());
        this.moleculeImages.add(new HFNode().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.N2Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.N2ONode().toImage());
        this.moleculeImages.add(new NH3Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.NONode().toImage());
        this.moleculeImages.add(new NO2Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.O2Node().toImage());
        this.moleculeImages.add(new OF2Node().toImage());
        this.moleculeImages.add(new P4Node().toImage());
        this.moleculeImages.add(new PCl3Node().toImage());
        this.moleculeImages.add(new PCl5Node().toImage());
        this.moleculeImages.add(new PF3Node().toImage());
        this.moleculeImages.add(new HorizontalMoleculeNode.SNode().toImage());
        this.moleculeImages.add(new SO2Node().toImage());
        this.moleculeImages.add(new SO3Node().toImage());
        FaceNode faceNode = new FaceNode(40.0);
        this.faceImage = faceNode.toImage();
        this.imagePool = new ArrayList();
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                GameRewardNode.this.step();
            }
        });
        this.setBounds(pBounds);
        this.setAtomsVisible(true);
        this.setMoleculesVisible(true);
        this.setSmileyFacesVisible(true);
    }

    public void setLevel(int n, boolean bl) {
        block6: {
            block5: {
                if (!bl) break block5;
                this.setClockDelay(40);
                this.setPopulation(300);
                this.setMotionDelta(10);
                switch (n) {
                    case 1: {
                        this.setAtomsVisible(true);
                        this.setMoleculesVisible(false);
                        this.setSmileyFacesVisible(false);
                        break block6;
                    }
                    case 2: {
                        this.setAtomsVisible(false);
                        this.setMoleculesVisible(true);
                        this.setSmileyFacesVisible(false);
                        break block6;
                    }
                    case 3: {
                        this.setAtomsVisible(false);
                        this.setMoleculesVisible(false);
                        this.setSmileyFacesVisible(true);
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported level: " + n);
                    }
                }
            }
            this.setClockDelay(40);
            this.setPopulation(50);
            this.setMotionDelta(2);
            this.setAtomsVisible(false);
            this.setMoleculesVisible(false);
            this.setSmileyFacesVisible(false);
        }
    }

    public boolean setBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.isEmpty()) {
            throw new IllegalArgumentException("bounds are empty");
        }
        boolean bl = false;
        if (!rectangle2D.equals(this.getBounds())) {
            bl = super.setBounds(rectangle2D);
            this.updateImages(true);
        }
        return bl;
    }

    private void setClockDelay(int n) {
        this.clock.setDelay(n);
    }

    private void setPopulation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("population must be > 0: " + n);
        }
        if (n != this.getPopulation()) {
            this.population = n;
            this.updateImages(false);
        }
    }

    private int getPopulation() {
        return this.population;
    }

    private void setMotionDelta(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("motionDelta must be > 0: " + n);
        }
        if (n != this.getMotionDelta()) {
            this.motionDelta = n;
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                if (!(this.getChild(i) instanceof MovingImageNode)) continue;
                int n2 = (int)Math.max(1.0, Math.random() * (double)n);
                ((MovingImageNode)this.getChild(i)).setMotionDelta(n2);
            }
        }
    }

    private int getMotionDelta() {
        return this.motionDelta;
    }

    private void setSmileyFacesVisible(boolean bl) {
        if (bl != this.isSmileyFacesVisible()) {
            if (bl) {
                this.imagePool.add(this.faceImage);
            } else {
                this.imagePool.remove(this.faceImage);
            }
            this.updateImages(true);
        }
    }

    private boolean isSmileyFacesVisible() {
        return this.imagePool.contains(this.faceImage);
    }

    private void setAtomsVisible(boolean bl) {
        if (bl != this.isAtomsVisible()) {
            if (bl) {
                this.imagePool.addAll(this.atomImages);
            } else {
                this.imagePool.removeAll(this.atomImages);
            }
            this.updateImages(true);
        }
    }

    private boolean isAtomsVisible() {
        return this.imagePool.contains(this.atomImages.get(0));
    }

    private void setMoleculesVisible(boolean bl) {
        if (bl != this.isMoleculesVisible()) {
            if (bl) {
                this.imagePool.addAll(this.moleculeImages);
            } else {
                this.imagePool.removeAll(this.moleculeImages);
            }
            this.updateImages(true);
        }
    }

    private boolean isMoleculesVisible() {
        return this.imagePool.contains(this.moleculeImages.get(0));
    }

    private void updateImages(boolean bl) {
        block5: {
            if (bl) {
                this.removeAllChildren();
            }
            if (this.imagePool.size() <= 0) break block5;
            if (this.getChildrenCount() > this.population) {
                while (this.getChildrenCount() > this.population) {
                    this.removeChild(this.getChildrenCount() - 1);
                }
            } else {
                while (this.getChildrenCount() < this.population) {
                    this.addRandomNode();
                }
            }
        }
    }

    private void addRandomNode() {
        int n = (int)Math.max(1.0, Math.random() * (double)this.motionDelta);
        int n2 = (int)(Math.random() * (double)this.imagePool.size());
        MovingImageNode movingImageNode = new MovingImageNode(this.imagePool.get(n2), n);
        this.addChild(movingImageNode);
        PBounds pBounds = this.getBoundsReference();
        Point2D point2D = this.getRandomPoint(pBounds);
        double d = point2D.getX() - movingImageNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = point2D.getY() - movingImageNode.getFullBoundsReference().getHeight() / 2.0;
        movingImageNode.setOffset(d, d2);
    }

    private Point2D getRandomPoint(PBounds pBounds) {
        double d = pBounds.getX() + Math.random() * pBounds.getWidth();
        double d2 = pBounds.getY() + Math.random() * pBounds.getHeight();
        return new Point2D.Double(d, d2);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.play();
        } else {
            this.pause();
        }
    }

    public void play() {
        this.clock.start();
    }

    public void pause() {
        this.clock.pause();
    }

    public boolean isRunning() {
        return this.clock.isRunning();
    }

    private void step() {
        PBounds pBounds = this.getBoundsReference();
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            if (!(this.getChild(i) instanceof MovingImageNode)) continue;
            this.motionStrategy.step((MovingImageNode)this.getChild(i), pBounds);
        }
    }

    public static class FallingMotionStrategy
    implements IMotionStrategy {
        public void step(MovingImageNode movingImageNode, PBounds pBounds) {
            double d = movingImageNode.getYOffset() + (double)movingImageNode.getMotionDelta();
            if (d > pBounds.getMaxY()) {
                d = pBounds.getMinY() - movingImageNode.getFullBoundsReference().getHeight();
            }
            movingImageNode.setOffset(movingImageNode.getXOffset(), d);
        }
    }

    public static interface IMotionStrategy {
        public void step(MovingImageNode var1, PBounds var2);
    }

    private static class MovingImageNode
    extends PImage {
        private int motionDelta;

        public MovingImageNode(Image image, int n) {
            super(image);
            this.motionDelta = n;
        }

        public int getMotionDelta() {
            return this.motionDelta;
        }

        public void setMotionDelta(int n) {
            this.motionDelta = n;
        }
    }
}

