/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.EquationTerm;
import edu.colorado.phet.balancingchemicalequations.view.HorizontalAligner;
import edu.colorado.phet.balancingchemicalequations.view.PlusNode;
import edu.colorado.phet.balancingchemicalequations.view.RightArrowNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.controls.IntegerSpinner;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquationNode
extends PhetPNode {
    private static final PhetFont FONT = new PhetFont(30);
    private static final Color SYMBOL_COLOR = Color.BLACK;
    private static final Color COEFFICIENT_COLOR = Color.BLACK;
    private final IntegerRange coefficientRange;
    private final HorizontalAligner aligner;
    private final ArrayList<TermNode> termNodes;
    private final SimpleObserver coefficientsObserver;
    private final RightArrowNode arrowNode;
    private final PNode termsParent;
    private Equation equation;
    private boolean editable;
    private boolean balancedHighlightEnabled;

    public EquationNode(final Property<Equation> property, IntegerRange integerRange, HorizontalAligner horizontalAligner) {
        this.coefficientRange = integerRange;
        this.editable = true;
        this.aligner = horizontalAligner;
        this.termNodes = new ArrayList();
        this.balancedHighlightEnabled = true;
        this.arrowNode = new RightArrowNode(property.get().isBalanced());
        this.addChild(this.arrowNode);
        double d = horizontalAligner.getCenterXOffset() - this.arrowNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = SymbolNode.getCapHeight() / 2.0;
        this.arrowNode.setOffset(d, d2);
        this.termsParent = new PhetPNode();
        this.addChild(this.termsParent);
        this.coefficientsObserver = new SimpleObserver(){

            public void update() {
                EquationNode.this.arrowNode.setHighlighted(EquationNode.this.equation.isBalanced() && EquationNode.this.balancedHighlightEnabled);
            }
        };
        this.equation = property.get();
        property.addObserver(new SimpleObserver(){

            public void update() {
                EquationNode.this.equation.removeCoefficientsObserver(EquationNode.this.coefficientsObserver);
                EquationNode.this.equation = (Equation)property.get();
                EquationNode.this.equation.addCoefficientsObserver(EquationNode.this.coefficientsObserver);
                EquationNode.this.updateNode();
            }
        });
    }

    public void setEditable(boolean bl) {
        if (bl != this.editable) {
            this.editable = bl;
            for (TermNode termNode : this.termNodes) {
                termNode.setEditable(bl);
            }
        }
    }

    public void setBalancedHighlightEnabled(boolean bl) {
        if (bl != this.balancedHighlightEnabled) {
            this.balancedHighlightEnabled = bl;
            this.arrowNode.setHighlighted(this.equation.isBalanced() && this.balancedHighlightEnabled);
        }
    }

    private void updateNode() {
        this.termsParent.removeAllChildren();
        for (TermNode termNode : this.termNodes) {
            termNode.cleanup();
        }
        this.termNodes.clear();
        this.updateSideOfEquation(this.equation.getReactants(), this.aligner.getReactantXOffsets(this.equation));
        this.updateSideOfEquation(this.equation.getProducts(), this.aligner.getProductXOffsets(this.equation));
    }

    private void updateSideOfEquation(EquationTerm[] equationTermArray, double[] dArray) {
        assert (equationTermArray.length == dArray.length);
        for (int i = 0; i < equationTermArray.length; ++i) {
            TermNode termNode = new TermNode(this.coefficientRange, equationTermArray[i], this.editable);
            this.termNodes.add(termNode);
            this.termsParent.addChild(termNode);
            termNode.setOffset(dArray[i] - termNode.getFullBoundsReference().getWidth() / 2.0, 0.0);
            if (equationTermArray.length <= 1 || i >= equationTermArray.length - 1) continue;
            PlusNode plusNode = new PlusNode();
            this.termsParent.addChild(plusNode);
            double d = dArray[i] + (dArray[i + 1] - dArray[i]) / 2.0 - plusNode.getFullBoundsReference().getWidth() / 2.0;
            double d2 = d - termNode.getFullBoundsReference().getMaxX();
            if (d2 < 20.0) {
                d += 20.0 - d2;
            }
            double d3 = SymbolNode.getCapHeight() / 2.0 - plusNode.getFullBoundsReference().getHeight() / 2.0;
            plusNode.setOffset(d, d3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoefficientNode
    extends PhetPNode {
        private final Property<Integer> coefficientProperty;
        private final SimpleObserver coefficientObserver;
        private final PText textNode = new PText();
        private final PSwing spinnerNode;

        public CoefficientNode(final IUserComponent iUserComponent, IntegerRange integerRange, final Property<Integer> property, boolean bl) {
            this.textNode.setFont(FONT);
            this.textNode.setTextPaint(COEFFICIENT_COLOR);
            final IntegerSpinner integerSpinner = new IntegerSpinner(iUserComponent, integerRange);
            integerSpinner.setForeground(COEFFICIENT_COLOR);
            integerSpinner.setFont(FONT);
            integerSpinner.setValue(property.get());
            integerSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    SimSharingManager.sendUserMessage(UserComponentChain.chain(iUserComponent, UserComponents.spinner), UserComponentTypes.spinner, UserActions.changed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, integerSpinner.getIntValue()));
                    property.set(integerSpinner.getIntValue());
                }
            });
            this.spinnerNode = new PSwing(integerSpinner);
            if (PhetUtilities.isMacintosh()) {
                this.spinnerNode.scale(1.75);
            }
            this.addChild(this.spinnerNode);
            this.addChild(this.textNode);
            this.textNode.setVisible(!bl);
            this.spinnerNode.setVisible(bl);
            this.coefficientProperty = property;
            this.coefficientObserver = new SimpleObserver(){

                public void update() {
                    integerSpinner.setIntValue((Integer)property.get());
                    CoefficientNode.this.textNode.setText(String.valueOf(property.get()));
                    CoefficientNode.this.textNode.setOffset(CoefficientNode.this.spinnerNode.getFullBoundsReference().getMaxX() - CoefficientNode.this.textNode.getFullBoundsReference().getWidth() - 12.0, 0.0);
                }
            };
            property.addObserver(this.coefficientObserver);
        }

        public void setEditable(boolean bl) {
            this.textNode.setVisible(!bl);
            this.spinnerNode.setVisible(bl);
        }

        public void removeCoefficientObserver() {
            this.coefficientProperty.removeObserver(this.coefficientObserver);
        }
    }

    private static class SymbolNode
    extends HTMLNode {
        public SymbolNode(String string) {
            super(string, SYMBOL_COLOR, FONT);
        }

        public static double getCapHeight() {
            return new SymbolNode("T").getFullBounds().getHeight();
        }
    }

    private static class TermNode
    extends PhetPNode {
        private final CoefficientNode coefficientNode;

        public TermNode(IntegerRange integerRange, EquationTerm equationTerm, boolean bl) {
            this.coefficientNode = new CoefficientNode(new UserComponent(equationTerm.getMolecule().getSymbol()), integerRange, equationTerm.getUserCoefficientProperty(), bl);
            this.addChild(this.coefficientNode);
            SymbolNode symbolNode = new SymbolNode(equationTerm.getMolecule().getSymbol());
            this.addChild(symbolNode);
            this.coefficientNode.setOffset(0.0, 0.0);
            symbolNode.setOffset(this.coefficientNode.getFullBoundsReference().getMaxX() + 5.0, 0.0);
        }

        public void setEditable(boolean bl) {
            this.coefficientNode.setEditable(bl);
        }

        public void cleanup() {
            this.coefficientNode.removeCoefficientObserver();
        }
    }
}

