/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.chemistry.molecules.AtomNode;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

class BarNode
extends PComposite {
    private static final PDimension MAX_BAR_SIZE = new PDimension(40.0, 135.0);
    private static final PDimension ARROW_SIZE = new PDimension(1.5 * MAX_BAR_SIZE.getWidth(), 15.0);
    private static final Stroke STROKE = new BasicStroke(1.5f);
    private static final Color STROKE_COLOR = Color.BLACK;
    private final Element element;
    private int numberOfAtoms;

    public BarNode(Element element, int n) {
        this.element = element;
        this.numberOfAtoms = n;
        this.update();
    }

    private void update() {
        this.removeAllChildren();
        PPath pPath = new PPath();
        this.addChild(pPath);
        pPath.setStroke(STROKE);
        pPath.setStrokePaint(STROKE_COLOR);
        pPath.setPaint(this.element.getColor());
        if (this.numberOfAtoms <= 12) {
            double d = MAX_BAR_SIZE.getHeight() * ((double)this.numberOfAtoms / 12.0);
            if (d == 0.0) {
                d = 0.001 * MAX_BAR_SIZE.getHeight();
            }
            pPath.setPathTo(new Rectangle2D.Double(-MAX_BAR_SIZE.getWidth() / 2.0, -d, MAX_BAR_SIZE.getWidth(), d));
        } else {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, (float)(-MAX_BAR_SIZE.getHeight()));
            generalPath.lineTo((float)ARROW_SIZE.getWidth() / 2.0f, (float)(-(MAX_BAR_SIZE.getHeight() - ARROW_SIZE.getHeight())));
            generalPath.lineTo((float)MAX_BAR_SIZE.getWidth() / 2.0f, (float)(-(MAX_BAR_SIZE.getHeight() - ARROW_SIZE.getHeight())));
            generalPath.lineTo((float)MAX_BAR_SIZE.getWidth() / 2.0f, 0.0f);
            generalPath.lineTo((float)(-MAX_BAR_SIZE.getWidth()) / 2.0f, 0.0f);
            generalPath.lineTo((float)(-MAX_BAR_SIZE.getWidth()) / 2.0f, (float)(-(MAX_BAR_SIZE.getHeight() - ARROW_SIZE.getHeight())));
            generalPath.lineTo((float)(-ARROW_SIZE.getWidth()) / 2.0f, (float)(-(MAX_BAR_SIZE.getHeight() - ARROW_SIZE.getHeight())));
            generalPath.closePath();
            pPath.setPathTo(generalPath);
        }
        pPath.setVisible(this.numberOfAtoms > 0);
        AtomNode atomNode = new AtomNode(this.element);
        this.addChild(atomNode);
        HTMLNode hTMLNode = new HTMLNode(this.element.getSymbol());
        hTMLNode.setFont(new PhetFont(24));
        this.addChild(hTMLNode);
        PText pText = new PText(String.valueOf(this.numberOfAtoms));
        pText.setFont(new PhetFont(18));
        this.addChild(pText);
        double d = ARROW_SIZE.getWidth() + 10.0;
        PPath pPath2 = new PPath(new Rectangle2D.Double(-d / 2.0, -1.0, d, 1.0));
        pPath2.setStroke(STROKE);
        this.addChild(pPath2);
        pPath2.setVisible(false);
        double d2 = 0.0;
        double d3 = 0.0;
        pPath.setOffset(d2, d3);
        pPath2.setOffset(pPath.getOffset());
        d2 = pPath2.getFullBoundsReference().getCenterX();
        d3 = pPath2.getFullBoundsReference().getMaxY() + 4.0;
        hTMLNode.setOffset(d2, d3);
        d2 = pPath2.getFullBoundsReference().getCenterX() - atomNode.getFullBoundsReference().getWidth() / 2.0 - 4.0;
        d3 = atomNode.getFullBoundsReference().getHeight() < hTMLNode.getFullBoundsReference().getHeight() ? hTMLNode.getFullBoundsReference().getCenterY() : hTMLNode.getFullBoundsReference().getMinY() + atomNode.getFullBoundsReference().getHeight() / 2.0;
        ((PNode)atomNode).setOffset(d2, d3);
        d2 = pPath2.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0;
        d3 = pPath.getFullBoundsReference().getMinY() - 4.0 - pText.getFullBoundsReference().getHeight();
        pText.setOffset(d2, d3);
    }
}

