/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.balancingchemicalequations.BCEConstants;
import edu.colorado.phet.balancingchemicalequations.model.AtomCount;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.view.BarNode;
import edu.colorado.phet.balancingchemicalequations.view.HorizontalAligner;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChartsNode
extends PComposite {
    private final HorizontalAligner aligner;
    private final EqualsSignNode equalsSignNode;
    private final NotEqualsSignNode notEqualsSignNode;
    private final PNode reactantsChartParent;
    private final PNode productsChartParent;
    private final SimpleObserver coefficientsObserver;
    private Equation equation;

    public BarChartsNode(final Property<Equation> property, HorizontalAligner horizontalAligner) {
        this.aligner = horizontalAligner;
        this.reactantsChartParent = new PComposite();
        this.addChild(this.reactantsChartParent);
        this.productsChartParent = new PComposite();
        this.addChild(this.productsChartParent);
        this.equalsSignNode = new EqualsSignNode(property.get().isBalanced());
        this.addChild(this.equalsSignNode);
        this.notEqualsSignNode = new NotEqualsSignNode();
        this.addChild(this.notEqualsSignNode);
        this.coefficientsObserver = new SimpleObserver(){

            public void update() {
                BarChartsNode.this.updateNode();
            }
        };
        this.equation = property.get();
        property.addObserver(new SimpleObserver(){

            public void update() {
                BarChartsNode.this.equation.removeCoefficientsObserver(BarChartsNode.this.coefficientsObserver);
                BarChartsNode.this.equation = (Equation)property.get();
                BarChartsNode.this.equation.addCoefficientsObserver(BarChartsNode.this.coefficientsObserver);
            }
        });
    }

    private void updateNode() {
        this.updateChart(this.reactantsChartParent, true);
        this.updateChart(this.productsChartParent, false);
        this.updateEqualitySign();
        this.updateLayout();
    }

    private void updateChart(PNode pNode, boolean bl) {
        pNode.removeAllChildren();
        double d = 0.0;
        ArrayList<AtomCount> arrayList = this.equation.getAtomCounts();
        for (AtomCount atomCount : arrayList) {
            int n = bl ? atomCount.getReactantsCount() : atomCount.getProductsCount();
            BarNode barNode = new BarNode(atomCount.getElement(), n);
            barNode.setOffset(d, 0.0);
            pNode.addChild(barNode);
            d = barNode.getFullBoundsReference().getMaxX() + 90.0;
        }
    }

    private void updateEqualitySign() {
        this.equalsSignNode.setVisible(this.equation.isBalanced());
        this.notEqualsSignNode.setVisible(!this.equalsSignNode.getVisible());
        this.equalsSignNode.setHighlighted(this.equation.isBalanced());
    }

    private void updateLayout() {
        double d = this.aligner.getCenterXOffset() - this.equalsSignNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = -this.equalsSignNode.getFullBoundsReference().getHeight() / 2.0;
        this.equalsSignNode.setOffset(d, d2);
        this.notEqualsSignNode.setOffset(d, d2);
        d = this.equalsSignNode.getFullBoundsReference().getMinX() - this.reactantsChartParent.getFullBoundsReference().getWidth() - PNodeLayoutUtils.getOriginXOffset(this.reactantsChartParent) - 120.0;
        d2 = 0.0;
        this.reactantsChartParent.setOffset(d, d2);
        d = this.equalsSignNode.getFullBoundsReference().getMaxX() - PNodeLayoutUtils.getOriginXOffset(this.productsChartParent) + 120.0;
        d2 = 0.0;
        this.productsChartParent.setOffset(d, d2);
    }

    private static class EqualsSignNode
    extends PComposite {
        private final PPath topBarNode;
        private final PPath bottomBarNode;

        public EqualsSignNode(boolean bl) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 50.0, 10.0);
            BasicStroke basicStroke = new BasicStroke(1.5f);
            Color color = Color.BLACK;
            this.topBarNode = new PPath(double_);
            this.topBarNode.setStroke(basicStroke);
            this.topBarNode.setStrokePaint(color);
            this.addChild(this.topBarNode);
            this.bottomBarNode = new PPath(double_);
            this.bottomBarNode.setStroke(basicStroke);
            this.bottomBarNode.setStrokePaint(color);
            this.addChild(this.bottomBarNode);
            this.topBarNode.setOffset(0.0, 0.0);
            this.bottomBarNode.setOffset(0.0, 20.0);
            this.setHighlighted(bl);
        }

        public void setHighlighted(boolean bl) {
            this.topBarNode.setPaint(bl ? BCEConstants.BALANCED_HIGHLIGHT_COLOR : BCEConstants.UNBALANCED_COLOR);
            this.bottomBarNode.setPaint(bl ? BCEConstants.BALANCED_HIGHLIGHT_COLOR : BCEConstants.UNBALANCED_COLOR);
        }
    }

    private static class NotEqualsSignNode
    extends PPath {
        public NotEqualsSignNode() {
            this.setStroke(new BasicStroke(1.0f));
            this.setStrokePaint(Color.BLACK);
            this.setPaint(BCEConstants.UNBALANCED_COLOR);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 50.0, 10.0);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 20.0, 50.0, 10.0);
            Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 10.0, 50.0, 10.0);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(-75.0), 25.0, 15.0);
            Shape shape = affineTransform.createTransformedShape(double_3);
            Area area = new Area(double_);
            area.add(new Area(shape));
            area.add(new Area(double_2));
            this.setPathTo(area);
        }
    }
}

