/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.module.game;

import edu.colorado.phet.balancingchemicalequations.BCEGlobalProperties;
import edu.colorado.phet.balancingchemicalequations.BCEModule;
import edu.colorado.phet.balancingchemicalequations.BCESimSharing;
import edu.colorado.phet.balancingchemicalequations.BCEStrings;
import edu.colorado.phet.balancingchemicalequations.model.BCEClock;
import edu.colorado.phet.balancingchemicalequations.module.game.GameCanvas;
import edu.colorado.phet.balancingchemicalequations.module.game.GameModel;

public class GameModule
extends BCEModule {
    private final GameModel model;
    private final GameCanvas canvas;
    private boolean rewardWasRunning = false;

    public GameModule(BCEGlobalProperties bCEGlobalProperties) {
        super(BCESimSharing.UserComponents.balancingGameTab, BCEStrings.BALANCING_GAME, new BCEClock(), true);
        this.model = new GameModel(bCEGlobalProperties);
        this.canvas = new GameCanvas(this.model, bCEGlobalProperties);
        this.setSimulationPanel(this.canvas);
    }

    public void activate() {
        super.activate();
        if (this.rewardWasRunning) {
            this.canvas.getRewardNode().play();
        }
    }

    public void deactivate() {
        super.deactivate();
        this.rewardWasRunning = this.canvas.getRewardNode().isRunning();
        this.canvas.getRewardNode().pause();
    }
}

