/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.module.game;

import edu.colorado.phet.balancingchemicalequations.BCEGlobalProperties;
import edu.colorado.phet.balancingchemicalequations.BCESimSharing;
import edu.colorado.phet.balancingchemicalequations.model.BCEClock;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.module.game.GameFactory;
import edu.colorado.phet.balancingchemicalequations.module.game.GameTimer;
import edu.colorado.phet.balancingchemicalequations.view.BalancedRepresentation;
import edu.colorado.phet.balancingchemicalequations.view.game.IBalancedRepresentationStrategy;
import edu.colorado.phet.common.games.GameSettings;
import edu.colorado.phet.common.games.GameSimSharing;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import java.util.ArrayList;
import java.util.HashMap;

class GameModel {
    private static HashMap<Integer, IBalancedRepresentationStrategy> BALANCED_REPRESENTATION_STRATEGIES = new HashMap<Integer, IBalancedRepresentationStrategy>(){
        {
            this.put(1, new IBalancedRepresentationStrategy.Constant(BalancedRepresentation.BALANCE_SCALES));
            this.put(2, new IBalancedRepresentationStrategy.Random());
            this.put(3, new IBalancedRepresentationStrategy.Constant(BalancedRepresentation.BAR_CHARTS));
        }
    };
    private static final IntegerRange COEFFICENTS_RANGE = new IntegerRange(0, 7);
    private static final IntegerRange LEVELS_RANGE = new IntegerRange(1, 3, 1);
    public final Property<Integer> points;
    public final Property<GameState> state = new Property<GameState>(GameState.START_GAME);
    public final Property<Equation> currentEquation;
    public final GameSettings settings;
    public final GameTimer timer;
    private final GameFactory equationsFactory;
    private final HashMap<Integer, Long> bestTimes;
    private ArrayList<Equation> equations;
    private int currentEquationIndex;
    private int attempts;
    private boolean isNewBestTime;
    private int currentPoints;
    private BalancedRepresentation balancedRepresentation;

    public GameModel(BCEGlobalProperties bCEGlobalProperties) {
        this.points = new Property<Integer>(0);
        this.equationsFactory = new GameFactory(bCEGlobalProperties.playAllEquations);
        this.settings = new GameSettings(LEVELS_RANGE, true, true);
        this.bestTimes = new HashMap();
        for (int i = this.settings.level.getMin(); i <= this.settings.level.getMax(); ++i) {
            this.bestTimes.put(i, 0L);
        }
        this.timer = new GameTimer(new BCEClock());
        this.equations = this.equationsFactory.createEquations(5, (Integer)this.settings.level.get());
        this.currentEquationIndex = 0;
        this.currentEquation = new Property<Equation>(this.equations.get(this.currentEquationIndex));
    }

    public void startGame() {
        this.equations = this.equationsFactory.createEquations(5, (Integer)this.settings.level.get());
        this.currentEquationIndex = 0;
        this.balancedRepresentation = BALANCED_REPRESENTATION_STRATEGIES.get(this.settings.level.get()).getBalancedRepresentation();
        this.attempts = 0;
        this.isNewBestTime = false;
        this.timer.start();
        this.currentPoints = 0;
        this.points.set(0);
        this.currentEquation.set(this.equations.get(this.currentEquationIndex));
        this.state.set(GameState.CHECK);
    }

    public void check() {
        ++this.attempts;
        SimSharingManager.sendModelMessage(GameSimSharing.ModelComponents.game, ModelComponentTypes.feature, BCESimSharing.Actions.guessChecked, ParameterSet.parameterSet((IParameterKey)BCESimSharing.Parameters.equation, this.currentEquation.get().getName()).with((IParameterKey)BCESimSharing.Parameters.attempts, this.attempts).with((IParameterKey)BCESimSharing.Parameters.isBalancedAndSimplified, this.currentEquation.get().isBalancedAndSimplified()).with((IParameterKey)BCESimSharing.Parameters.isBalanced, this.currentEquation.get().isBalanced()));
        if (this.currentEquation.get().isBalancedAndSimplified()) {
            this.currentPoints = this.attempts == 1 ? 2 : (this.attempts == 2 ? 1 : 0);
            this.points.set(this.points.get() + this.currentPoints);
            if (this.currentEquationIndex == this.equations.size() - 1) {
                this.timer.stop();
                long l = this.getBestTime((Integer)this.settings.level.get());
                if (this.isPerfectScore() && (l == 0L || this.timer.time.get() < l)) {
                    this.isNewBestTime = true;
                    this.bestTimes.put((Integer)this.settings.level.get(), this.timer.time.get());
                }
            }
            this.state.set(GameState.NEXT);
        } else if (this.attempts < 2) {
            this.state.set(GameState.TRY_AGAIN);
        } else {
            this.state.set(GameState.SHOW_ANSWER);
        }
    }

    public void tryAgain() {
        this.state.set(GameState.CHECK);
    }

    public void showAnswer() {
        this.state.set(GameState.NEXT);
    }

    public void next() {
        if (this.currentEquationIndex < this.equations.size() - 1) {
            this.attempts = 0;
            this.currentPoints = 0;
            this.balancedRepresentation = BALANCED_REPRESENTATION_STRATEGIES.get(this.settings.level.get()).getBalancedRepresentation();
            ++this.currentEquationIndex;
            this.currentEquation.set(this.equations.get(this.currentEquationIndex));
            this.state.set(GameState.CHECK);
        } else {
            this.state.set(GameState.NEW_GAME);
        }
    }

    public void newGame() {
        this.state.set(GameState.START_GAME);
    }

    public boolean isNewBestTime() {
        return this.isNewBestTime;
    }

    public long getBestTime(int n) {
        Long l = this.bestTimes.get(n);
        if (l == null) {
            l = 0L;
        }
        return l;
    }

    public int getCurrentPoints() {
        return this.currentPoints;
    }

    public IntegerRange getCoefficientsRange() {
        return COEFFICENTS_RANGE;
    }

    public int getCurrentEquationIndex() {
        return this.currentEquationIndex;
    }

    public int getNumberOfEquations() {
        return this.equations.size();
    }

    public int getPerfectScore() {
        return this.getNumberOfEquations() * 2;
    }

    public boolean isPerfectScore() {
        return this.points.get().intValue() == this.getPerfectScore();
    }

    public BalancedRepresentation getBalancedRepresentation() {
        return this.balancedRepresentation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GameState
    extends Enum<GameState> {
        public static final /* enum */ GameState START_GAME = new GameState();
        public static final /* enum */ GameState CHECK = new GameState();
        public static final /* enum */ GameState TRY_AGAIN = new GameState();
        public static final /* enum */ GameState SHOW_ANSWER = new GameState();
        public static final /* enum */ GameState NEXT = new GameState();
        public static final /* enum */ GameState NEW_GAME = new GameState();
        private static final /* synthetic */ GameState[] $VALUES;

        public static GameState[] values() {
            return (GameState[])$VALUES.clone();
        }

        static {
            $VALUES = new GameState[]{START_GAME, CHECK, TRY_AGAIN, SHOW_ANSWER, NEXT, NEW_GAME};
        }
    }
}

