/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.model;

import edu.colorado.phet.balancingchemicalequations.BCEStrings;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.EquationTerm;
import edu.colorado.phet.balancingchemicalequations.model.Molecule;

public abstract class SynthesisEquation
extends Equation {
    private SynthesisEquation(int n, Molecule molecule, int n2, Molecule molecule2, int n3, Molecule molecule3) {
        super(new EquationTerm[]{new EquationTerm(n, molecule), new EquationTerm(n2, molecule2)}, new EquationTerm[]{new EquationTerm(n3, molecule3)});
    }

    public static class Synthesis_2C_O2_2CO
    extends SynthesisEquation {
        public Synthesis_2C_O2_2CO() {
            super(2, new Molecule.CMolecule(), 1, new Molecule.O2(), 2, new Molecule.CO());
        }
    }

    public static class Synthesis_2H2_O2_2H2O
    extends SynthesisEquation {
        public Synthesis_2H2_O2_2H2O() {
            super(2, new Molecule.H2(), 1, new Molecule.O2(), 2, new Molecule.H2O());
        }
    }

    public static class Synthesis_2N2_O2_2N2O
    extends SynthesisEquation {
        public Synthesis_2N2_O2_2N2O() {
            super(2, new Molecule.N2(), 1, new Molecule.O2(), 2, new Molecule.N2O());
        }
    }

    public static class Synthesis_C2H2_2H2_C2H6
    extends SynthesisEquation {
        public Synthesis_C2H2_2H2_C2H6() {
            super(1, new Molecule.C2H2(), 2, new Molecule.H2(), 1, new Molecule.C2H6());
        }
    }

    public static class Synthesis_CH2O_H2_CH3OH
    extends SynthesisEquation {
        public Synthesis_CH2O_H2_CH3OH() {
            super(1, new Molecule.CH2O(), 1, new Molecule.H2(), 1, new Molecule.CH3OH());
        }
    }

    public static class Synthesis_C_2S_CS2
    extends SynthesisEquation {
        public Synthesis_C_2S_CS2() {
            super(1, new Molecule.CMolecule(), 2, new Molecule.SMolecule(), 1, new Molecule.CS2());
        }
    }

    public static class Synthesis_C_O2_CO2
    extends SynthesisEquation {
        public Synthesis_C_O2_CO2() {
            super(1, new Molecule.CMolecule(), 1, new Molecule.O2(), 1, new Molecule.CO2());
        }
    }

    public static class Synthesis_H2_F2_2HF
    extends SynthesisEquation {
        public Synthesis_H2_F2_2HF() {
            super(1, new Molecule.H2(), 1, new Molecule.F2(), 2, new Molecule.HF());
        }
    }

    public static class Synthesis_N2_3H2_2NH3
    extends SynthesisEquation {
        public Synthesis_N2_3H2_2NH3() {
            super(1, new Molecule.N2(), 3, new Molecule.H2(), 2, new Molecule.NH3());
        }

        public String getName() {
            return BCEStrings.MAKE_AMMONIA;
        }
    }

    public static class Synthesis_P4_6F2_4PF3
    extends SynthesisEquation {
        public Synthesis_P4_6F2_4PF3() {
            super(1, new Molecule.P4(), 6, new Molecule.F2(), 4, new Molecule.PF3());
        }
    }

    public static class Synthesis_P4_6H2_4PH3
    extends SynthesisEquation {
        public Synthesis_P4_6H2_4PH3() {
            super(1, new Molecule.P4(), 6, new Molecule.H2(), 4, new Molecule.PH3());
        }
    }
}

