/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.developer;

import edu.colorado.phet.balancingchemicalequations.developer.PreviewMoleculesCanvas;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;

public class PreviewMoleculesMenuItem
extends JCheckBoxMenuItem {
    private JDialog dialog;

    public PreviewMoleculesMenuItem(final Frame frame) {
        super("Preview molecules...");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewMoleculesMenuItem.this.handleDialog(frame);
            }
        });
    }

    private void handleDialog(Frame frame) {
        if (this.isSelected()) {
            this.dialog = new DeveloperMoleculesDialog(frame);
            this.dialog.setVisible(true);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    this.cleanup();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.cleanup();
                }

                private void cleanup() {
                    PreviewMoleculesMenuItem.this.setSelected(false);
                    PreviewMoleculesMenuItem.this.dialog = null;
                }
            });
        } else {
            this.dialog.dispose();
        }
    }

    private static class DeveloperMoleculesDialog
    extends JDialog {
        public DeveloperMoleculesDialog(Frame frame) {
            super(frame);
            this.setTitle("Molecules");
            this.setModal(false);
            this.setResizable(true);
            this.setContentPane(new PreviewMoleculesCanvas(frame));
            this.pack();
            SwingUtils.centerInParent(this);
        }
    }
}

