/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.developer;

import edu.colorado.phet.balancingchemicalequations.BCEGlobalProperties;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorsMenuItem
extends JCheckBoxMenuItem {
    private final BCEGlobalProperties globalProperties;
    private DeveloperColorsDialog dialog;

    public ColorsMenuItem(final BCEGlobalProperties bCEGlobalProperties) {
        super("Colors...");
        this.globalProperties = bCEGlobalProperties;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorsMenuItem.this.handleColorsDialog();
            }
        });
        bCEGlobalProperties.canvasColor.addObserver(new SimpleObserver(){

            public void update() {
                if (ColorsMenuItem.this.dialog != null) {
                    ColorsMenuItem.this.dialog.setCanvasColor(bCEGlobalProperties.canvasColor.get());
                }
            }
        });
        bCEGlobalProperties.boxColor.addObserver(new SimpleObserver(){

            public void update() {
                if (ColorsMenuItem.this.dialog != null) {
                    ColorsMenuItem.this.dialog.setBoxColor(bCEGlobalProperties.boxColor.get());
                }
            }
        });
    }

    private void handleColorsDialog() {
        if (this.isSelected()) {
            this.dialog = new DeveloperColorsDialog(this.globalProperties);
            this.dialog.setVisible(true);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    this.cleanup();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.cleanup();
                }

                private void cleanup() {
                    ColorsMenuItem.this.setSelected(false);
                    ColorsMenuItem.this.dialog = null;
                }
            });
        } else {
            this.dialog.dispose();
        }
    }

    private static class DeveloperColorsDialog
    extends PaintImmediateDialog {
        private final ColorControl canvasColorControl;
        private final ColorControl boxColorControl;

        public DeveloperColorsDialog(final BCEGlobalProperties bCEGlobalProperties) {
            super(bCEGlobalProperties.frame);
            super.setTitle("Colors");
            super.setModal(false);
            super.setResizable(false);
            this.canvasColorControl = new ColorControl(bCEGlobalProperties.frame, "play area:", bCEGlobalProperties.canvasColor.get());
            this.canvasColorControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    bCEGlobalProperties.canvasColor.set(DeveloperColorsDialog.this.canvasColorControl.getColor());
                }
            });
            this.boxColorControl = new ColorControl(bCEGlobalProperties.frame, "boxes:", bCEGlobalProperties.boxColor.get());
            this.boxColorControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    bCEGlobalProperties.boxColor.set(DeveloperColorsDialog.this.boxColorControl.getColor());
                }
            });
            GridPanel gridPanel = new GridPanel();
            gridPanel.setAnchor(GridPanel.Anchor.EAST);
            gridPanel.setInsets(new Insets(5, 5, 5, 5));
            gridPanel.setGridX(0);
            gridPanel.setGridY(-1);
            gridPanel.add(this.canvasColorControl);
            gridPanel.add(this.boxColorControl);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel.add(gridPanel);
            this.getContentPane().add(jPanel);
            this.pack();
            SwingUtils.centerInParent(this);
        }

        public void setCanvasColor(Color color) {
            this.canvasColorControl.setColor(color);
        }

        public void setBoxColor(Color color) {
            this.boxColorControl.setColor(color);
        }
    }
}

