/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.model;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallenge;
import edu.colorado.phet.balanceandtorque.game.model.ChallengeViewConfig;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.balanceandtorque.game.model.TiltPrediction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelComponentType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiltPredictionChallenge
extends BalanceGameChallenge {
    private static final ChallengeViewConfig VIEW_CONFIG = new ChallengeViewConfig(BalanceAndTorqueResources.Strings.WHAT_WILL_HAPPEN, false, true);

    public TiltPredictionChallenge(List<MassDistancePair> list) {
        super(ColumnState.DOUBLE_COLUMNS, 2);
        this.fixedMassDistancePairs.addAll(list);
        this.movableMasses.addAll(this.movableMasses);
    }

    @Override
    public ChallengeViewConfig getChallengeViewConfig() {
        return VIEW_CONFIG;
    }

    @Override
    public IModelComponentType getModelComponentType() {
        return BalanceAndTorqueSimSharing.ModelComponentTypes.tiltPredictionChallenge;
    }

    public static TiltPredictionChallenge create(Mass mass, double d, Mass mass2, double d2) {
        ArrayList<MassDistancePair> arrayList = new ArrayList<MassDistancePair>();
        MassDistancePair massDistancePair = new MassDistancePair(mass, -d);
        arrayList.add(massDistancePair);
        MassDistancePair massDistancePair2 = new MassDistancePair(mass2, -d2);
        arrayList.add(massDistancePair2);
        return new TiltPredictionChallenge(arrayList);
    }

    @Override
    public String getCorrectAnswerString() {
        assert (this.movableMasses.size() == 0);
        double d = 0.0;
        for (MassDistancePair massDistancePair : this.fixedMassDistancePairs) {
            d += massDistancePair.distance * massDistancePair.mass.getMass();
        }
        if (d == 0.0) {
            return TiltPrediction.STAY_BALANCED.toString();
        }
        if (d < 0.0) {
            return TiltPrediction.TILT_DOWN_ON_LEFT_SIDE.toString();
        }
        return TiltPrediction.TILT_DOWN_ON_RIGHT_SIDE.toString();
    }
}

