/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.model;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.AttachmentBar;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.FulcrumAbovePlank;
import edu.colorado.phet.balanceandtorque.common.model.LevelSupportColumn;
import edu.colorado.phet.balanceandtorque.common.model.Plank;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.model.masses.TiltSupportColumn;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallenge;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallengeFactory;
import edu.colorado.phet.balanceandtorque.game.model.BalanceMassesChallenge;
import edu.colorado.phet.balanceandtorque.game.model.MassDeductionChallenge;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.balanceandtorque.game.model.TiltPrediction;
import edu.colorado.phet.balanceandtorque.game.model.TiltPredictionChallenge;
import edu.colorado.phet.common.games.GameSettings;
import edu.colorado.phet.common.games.GameSimSharing;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelComponentType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalanceGameModel {
    private final ConstantDtClock clock = new ConstantDtClock(30.0);
    private long gameStartTime = 0L;
    public final GameSettings gameSettings = new GameSettings(new IntegerRange(1, 4, 1), true, true);
    private final HashMap<Integer, Double> mapLevelToBestTime = new HashMap();
    private final Property<Integer> scoreProperty = new Property<Integer>(0);
    public final Property<GameState> gameStateProperty = new Property<GameState>(GameState.OBTAINING_GAME_SETUP);
    private int challengeCount = 0;
    private int incorrectGuessesOnCurrentChallenge = 0;
    private List<BalanceGameChallenge> challengeList;
    public ObservableList<MassDistancePair> fixedMasses = new ObservableList();
    public ObservableList<Mass> movableMasses = new ObservableList();
    private final TiltSupportColumn tiltSupportColumn;
    private final List<LevelSupportColumn> levelSupportColumns = new ArrayList<LevelSupportColumn>(){
        {
            this.add(new LevelSupportColumn(0.75, -1.625));
            this.add(new LevelSupportColumn(0.75, 1.625));
        }
    };
    public final Property<ColumnState> supportColumnState = new Property<ColumnState>(ColumnState.SINGLE_COLUMN);
    private final Plank plank = new Plank(this.clock, new Point2D.Double(0.0, 0.75), new Point2D.Double(0.0, 0.85), this.supportColumnState);
    private final AttachmentBar attachmentBar = new AttachmentBar(this.plank);
    private final FulcrumAbovePlank fulcrum = new FulcrumAbovePlank(1.0, 0.85);

    public BalanceGameModel() {
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                BalanceGameModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        double d = 1.8;
        this.tiltSupportColumn = new TiltSupportColumn(0.75 + d * Math.tan(this.plank.getMaxTiltAngle()), d, -this.plank.getMaxTiltAngle());
    }

    public ConstantDtClock getClock() {
        return this.clock;
    }

    private void stepInTime(double d) {
        for (Mass object : new ArrayList<Mass>(this.movableMasses)) {
            object.stepInTime(d);
        }
        for (MassDistancePair massDistancePair : this.fixedMasses) {
            massDistancePair.mass.stepInTime(d);
        }
    }

    public FulcrumAbovePlank getFulcrum() {
        return this.fulcrum;
    }

    public Plank getPlank() {
        return this.plank;
    }

    public AttachmentBar getAttachmentBar() {
        return this.attachmentBar;
    }

    public int getMaximumPossibleScore() {
        return 12;
    }

    public GameSettings getGameSettings() {
        return this.gameSettings;
    }

    public int getLevel() {
        return (Integer)this.gameSettings.level.get();
    }

    public boolean isTimerEnabled() {
        return (Boolean)this.gameSettings.timerEnabled.get();
    }

    public double getElapsedTime() {
        return (double)(this.clock.getWallTime() - this.gameStartTime) / 1000.0;
    }

    public double getBestTime(int n) {
        assert (n > 0 && n <= 4);
        return this.mapLevelToBestTime.containsKey(n) ? this.mapLevelToBestTime.get(n) : Double.POSITIVE_INFINITY;
    }

    public boolean isNewBestTime() {
        return this.getElapsedTime() == this.getBestTime(this.getLevel()) && this.isTimerEnabled();
    }

    public boolean isBestTimeRecorded(int n) {
        return this.mapLevelToBestTime.containsKey(n);
    }

    public Property<Integer> getScoreProperty() {
        return this.scoreProperty;
    }

    public void showGameInitDialog() {
        this.gameStateProperty.set(GameState.OBTAINING_GAME_SETUP);
    }

    public void startGame() {
        this.scoreProperty.set(0);
        this.challengeCount = 0;
        this.incorrectGuessesOnCurrentChallenge = 0;
        this.gameStartTime = this.clock.getWallTime();
        this.challengeList = BalanceGameChallengeFactory.generateChallengeSet(this.getLevel());
        this.setChallenge(this.getCurrentChallenge(), this.getCurrentChallenge().initialColumnState);
        this.gameStateProperty.set(GameState.PRESENTING_INTERACTIVE_CHALLENGE);
    }

    public void checkAnswer() {
        assert (this.getCurrentChallenge() instanceof BalanceMassesChallenge);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (MassDistancePair massDistancePair : this.plank.getMassDistancePairs()) {
            if (!(massDistancePair.distance > 0.0)) continue;
            arrayList.add(massDistancePair.distance);
        }
        assert (arrayList.size() == 1);
        this.sendProposedAnswerMessage(BalanceAndTorqueSimSharing.DISTANCE_VALUE_FORMATTER.format((double)((Double)arrayList.get(0))));
        this.supportColumnState.set(ColumnState.NONE);
        this.handleProposedAnswer(this.plank.isBalanced());
    }

    public void checkAnswer(double d) {
        assert (this.getCurrentChallenge() instanceof MassDeductionChallenge);
        this.sendProposedAnswerMessage(Double.toString(d));
        this.handleProposedAnswer(d == this.getTotalFixedMassValue());
    }

    public void checkAnswer(TiltPrediction tiltPrediction) {
        assert (this.getCurrentChallenge() instanceof TiltPredictionChallenge);
        this.sendProposedAnswerMessage(tiltPrediction.toString());
        this.supportColumnState.set(ColumnState.NONE);
        this.handleProposedAnswer(tiltPrediction == TiltPrediction.TILT_DOWN_ON_LEFT_SIDE && this.plank.getTorqueDueToMasses() > 0.0 || tiltPrediction == TiltPrediction.TILT_DOWN_ON_RIGHT_SIDE && this.plank.getTorqueDueToMasses() < 0.0 || tiltPrediction == TiltPrediction.STAY_BALANCED && this.plank.getTorqueDueToMasses() == 0.0);
    }

    private void sendProposedAnswerMessage(String string) {
        SimSharingManager.sendModelMessage(GameSimSharing.ModelComponents.game, this.getCurrentChallenge().getModelComponentType(), BalanceAndTorqueSimSharing.ModelActions.proposedAnswerSubmitted, new ParameterSet(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.proposedAnswer, string)));
    }

    private void sendAnswerCheckResult(IModelComponentType iModelComponentType, boolean bl, int n) {
        SimSharingManager.sendModelMessage(GameSimSharing.ModelComponents.game, iModelComponentType, bl ? BalanceAndTorqueSimSharing.ModelActions.correctAnswerSubmitted : BalanceAndTorqueSimSharing.ModelActions.incorrectAnswerSubmitted, new ParameterSet(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.pointsEarned, n)));
    }

    public BalanceGameChallenge getCurrentChallenge() {
        if (this.challengeList == null || this.challengeList.size() <= this.challengeCount) {
            return null;
        }
        return this.challengeList.get(this.challengeCount);
    }

    private void handleProposedAnswer(boolean bl) {
        int n = 0;
        if (bl) {
            this.gameStateProperty.set(GameState.SHOWING_CORRECT_ANSWER_FEEDBACK);
            n = this.incorrectGuessesOnCurrentChallenge == 0 ? 2 : 2 - this.incorrectGuessesOnCurrentChallenge;
            this.scoreProperty.set(this.scoreProperty.get() + n);
        } else {
            ++this.incorrectGuessesOnCurrentChallenge;
            if (this.incorrectGuessesOnCurrentChallenge < this.getCurrentChallenge().maxAttemptsAllowed) {
                this.gameStateProperty.set(GameState.SHOWING_INCORRECT_ANSWER_FEEDBACK_TRY_AGAIN);
            } else {
                this.gameStateProperty.set(GameState.SHOWING_INCORRECT_ANSWER_FEEDBACK_MOVE_ON);
            }
        }
        this.sendAnswerCheckResult(this.challengeList.get(this.challengeCount).getModelComponentType(), bl, n);
    }

    public void nextChallenge() {
        ++this.challengeCount;
        this.incorrectGuessesOnCurrentChallenge = 0;
        if (this.challengeCount < this.challengeList.size()) {
            this.setChallenge(this.getCurrentChallenge(), this.getCurrentChallenge().initialColumnState);
            this.gameStateProperty.set(GameState.PRESENTING_INTERACTIVE_CHALLENGE);
        } else {
            double d;
            if (this.scoreProperty.get() == 12 && (d = this.getElapsedTime()) < this.getBestTime(this.getLevel())) {
                this.mapLevelToBestTime.put(this.getLevel(), d);
            }
            this.gameStateProperty.set(GameState.SHOWING_GAME_RESULTS);
        }
    }

    private void setChallenge(BalanceGameChallenge balanceGameChallenge, ColumnState columnState) {
        this.plank.removeAllMasses();
        this.supportColumnState.set(ColumnState.DOUBLE_COLUMNS);
        this.fixedMasses.clear();
        for (Mass object : this.movableMasses) {
            object.userControlled.removeAllObservers();
        }
        this.movableMasses.clear();
        for (MassDistancePair massDistancePair : balanceGameChallenge.fixedMassDistancePairs) {
            this.fixedMasses.add(massDistancePair);
            this.plank.addMassToSurface(massDistancePair.mass, massDistancePair.distance);
        }
        for (final Mass mass : balanceGameChallenge.movableMasses) {
            final Point2D.Double double_ = new Point2D.Double(3.0, 0.0);
            mass.setPosition(double_);
            mass.userControlled.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    if (!bl.booleanValue() && !BalanceGameModel.this.plank.addMassToSurface(mass)) {
                        mass.setPosition(double_);
                    }
                }
            });
            this.movableMasses.add(mass);
        }
        this.supportColumnState.set(columnState);
        SimSharingManager.sendModelMessage(GameSimSharing.ModelComponents.game, balanceGameChallenge.getModelComponentType(), BalanceAndTorqueSimSharing.ModelActions.challengePresented, this.plank.getMassStateParameterSet().with(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.correctAnswer, balanceGameChallenge.getCorrectAnswerString())));
    }

    public int getChallengeCurrentPointValue() {
        assert (2 > this.incorrectGuessesOnCurrentChallenge);
        return 2 - this.incorrectGuessesOnCurrentChallenge;
    }

    public void tryAgain() {
        this.supportColumnState.set(this.getCurrentChallenge().initialColumnState);
        this.gameStateProperty.set(GameState.PRESENTING_INTERACTIVE_CHALLENGE);
    }

    public void displayCorrectAnswer() {
        BalanceGameChallenge balanceGameChallenge = this.getCurrentChallenge();
        this.setChallenge(balanceGameChallenge, ColumnState.NONE);
        for (MassDistancePair massDistancePair : balanceGameChallenge.balancedConfiguration) {
            this.plank.addMassToSurface(massDistancePair.mass, massDistancePair.distance);
        }
        this.gameStateProperty.set(GameState.DISPLAYING_CORRECT_ANSWER);
    }

    public TiltSupportColumn getTiltSupportColumn() {
        return this.tiltSupportColumn;
    }

    public List<LevelSupportColumn> getLevelSupportColumns() {
        return this.levelSupportColumns;
    }

    public TiltPrediction getTipDirection() {
        if (this.plank.getTorqueDueToMasses() < 0.0) {
            return TiltPrediction.TILT_DOWN_ON_RIGHT_SIDE;
        }
        if (this.plank.getTorqueDueToMasses() > 0.0) {
            return TiltPrediction.TILT_DOWN_ON_LEFT_SIDE;
        }
        return TiltPrediction.STAY_BALANCED;
    }

    private double getTotalFixedMassValue() {
        double d = 0.0;
        for (MassDistancePair massDistancePair : this.getCurrentChallenge().fixedMassDistancePairs) {
            d += massDistancePair.mass.getMass();
        }
        return d;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GameState
    extends Enum<GameState> {
        public static final /* enum */ GameState OBTAINING_GAME_SETUP = new GameState();
        public static final /* enum */ GameState PRESENTING_INTERACTIVE_CHALLENGE = new GameState();
        public static final /* enum */ GameState SHOWING_CORRECT_ANSWER_FEEDBACK = new GameState();
        public static final /* enum */ GameState SHOWING_INCORRECT_ANSWER_FEEDBACK_TRY_AGAIN = new GameState();
        public static final /* enum */ GameState SHOWING_INCORRECT_ANSWER_FEEDBACK_MOVE_ON = new GameState();
        public static final /* enum */ GameState DISPLAYING_CORRECT_ANSWER = new GameState();
        public static final /* enum */ GameState SHOWING_GAME_RESULTS = new GameState();
        private static final /* synthetic */ GameState[] $VALUES;

        public static GameState[] values() {
            return (GameState[])$VALUES.clone();
        }

        static {
            $VALUES = new GameState[]{OBTAINING_GAME_SETUP, PRESENTING_INTERACTIVE_CHALLENGE, SHOWING_CORRECT_ANSWER_FEEDBACK, SHOWING_INCORRECT_ANSWER_FEEDBACK_TRY_AGAIN, SHOWING_INCORRECT_ANSWER_FEEDBACK_MOVE_ON, DISPLAYING_CORRECT_ANSWER, SHOWING_GAME_RESULTS};
        }
    }
}

