/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.model;

import edu.colorado.phet.balanceandtorque.common.model.Plank;
import edu.colorado.phet.balanceandtorque.common.model.masses.Barrel;
import edu.colorado.phet.balanceandtorque.common.model.masses.BigRock;
import edu.colorado.phet.balanceandtorque.common.model.masses.Boy;
import edu.colorado.phet.balanceandtorque.common.model.masses.BrickStack;
import edu.colorado.phet.balanceandtorque.common.model.masses.CinderBlock;
import edu.colorado.phet.balanceandtorque.common.model.masses.FireHydrant;
import edu.colorado.phet.balanceandtorque.common.model.masses.FlowerPot;
import edu.colorado.phet.balanceandtorque.common.model.masses.Girl;
import edu.colorado.phet.balanceandtorque.common.model.masses.LargeBucket;
import edu.colorado.phet.balanceandtorque.common.model.masses.LargeTrashCan;
import edu.colorado.phet.balanceandtorque.common.model.masses.Man;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.model.masses.MediumBucket;
import edu.colorado.phet.balanceandtorque.common.model.masses.MediumRock;
import edu.colorado.phet.balanceandtorque.common.model.masses.MediumTrashCan;
import edu.colorado.phet.balanceandtorque.common.model.masses.PottedPlant;
import edu.colorado.phet.balanceandtorque.common.model.masses.SmallBucket;
import edu.colorado.phet.balanceandtorque.common.model.masses.SmallRock;
import edu.colorado.phet.balanceandtorque.common.model.masses.SodaBottle;
import edu.colorado.phet.balanceandtorque.common.model.masses.Television;
import edu.colorado.phet.balanceandtorque.common.model.masses.TinyRock;
import edu.colorado.phet.balanceandtorque.common.model.masses.Tire;
import edu.colorado.phet.balanceandtorque.common.model.masses.Woman;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallenge;
import edu.colorado.phet.balanceandtorque.game.model.BalanceMassesChallenge;
import edu.colorado.phet.balanceandtorque.game.model.MassDeductionChallenge;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.balanceandtorque.game.model.TiltPredictionChallenge;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function2;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalanceGameChallengeFactory {
    private static final Random RAND = new Random();
    private static final double MAX_DISTANCE_FROM_BALANCE_CENTER_TO_MASS = (double)(Math.round(Plank.getLength() / 0.25 / 2.0) - 1L) * 0.25;
    private static final List<Mass> BALANCE_CHALLENGE_MASSES = new ArrayList<Mass>(){
        {
            this.add(new BrickStack(1));
            this.add(new BrickStack(2));
            this.add(new BrickStack(3));
            this.add(new BrickStack(4));
            this.add(new TinyRock(false));
            this.add(new SmallRock(false));
            this.add(new MediumRock(false));
            this.add(new BigRock(false));
            this.add(new Boy());
            this.add(new Girl());
            this.add(new Woman());
            this.add(new Man());
            this.add(new Barrel(false));
            this.add(new CinderBlock(false));
        }
    };
    private static final List<Mass> MYSTERY_MASSES = new ArrayList<Mass>(){
        {
            this.add(new FireHydrant(true));
            this.add(new Television(true));
            this.add(new LargeTrashCan(true));
            this.add(new MediumTrashCan(true));
            this.add(new FlowerPot(true));
            this.add(new SmallBucket(true));
            this.add(new MediumBucket(true));
            this.add(new LargeBucket(true));
            this.add(new PottedPlant(true));
            this.add(new SodaBottle(true));
            this.add(new Tire(true));
        }
    };
    private static final List<Mass> LOW_PROFILE_MASSES = new ArrayList<Mass>(){
        {
            this.add(new TinyRock(false));
            this.add(new SmallRock(false));
            this.add(new MediumRock(false));
            this.add(new CinderBlock(false));
        }
    };
    private static final List<BalanceGameChallenge> USED_BALANCE_CHALLENGES = new ArrayList<BalanceGameChallenge>();
    private static final List<BalanceGameChallenge> USED_MASS_DEDUCTION_CHALLENGES = new ArrayList<BalanceGameChallenge>();
    private static final List<BalanceGameChallenge> USED_TILT_PREDICTION_CHALLENGES = new ArrayList<BalanceGameChallenge>();
    private static final Function0<BalanceGameChallenge> SIMPLE_BALANCE_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateSimpleBalanceChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> SIMPLE_TILT_PREDICTION_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateSimpleTiltPredictionChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> SIMPLE_MASS_DEDUCTION_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateSimpleMassDeductionChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> EASY_BALANCE_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateEasyBalanceChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> EASY_MASS_DEDUCTION_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateEasyMassDeductionChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> EASY_TILT_PREDICTION_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateEasyTiltPredictionChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> MODERATE_BALANCE_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateModerateBalanceChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> MODERATE_MASS_DEDUCTION_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateModerateMassDeductionChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> MODERATE_TILT_PREDICTION_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateModerateTiltPredictionChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> ADVANCED_BALANCE_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateMultiMassBalanceChallenge();
        }
    };
    private static final Function0<BalanceGameChallenge> ADVANCED_TILT_PREDICTION_CHALLENGE_GENERATOR = new Function0<BalanceGameChallenge>(){

        @Override
        public BalanceGameChallenge apply() {
            return BalanceGameChallengeFactory.generateAdvancedTiltPredictionChallenge();
        }
    };
    private static final Function2<BalanceGameChallenge, List<BalanceGameChallenge>, Boolean> UNIQUE_MASSES_TEST = new Function2<BalanceGameChallenge, List<BalanceGameChallenge>, Boolean>(){

        @Override
        public Boolean apply(BalanceGameChallenge balanceGameChallenge, List<BalanceGameChallenge> list) {
            return BalanceGameChallengeFactory.usesUniqueMasses(balanceGameChallenge, list);
        }
    };
    private static final Function2<BalanceGameChallenge, List<BalanceGameChallenge>, Boolean> UNIQUE_FIXED_MASSES_TEST = new Function2<BalanceGameChallenge, List<BalanceGameChallenge>, Boolean>(){

        @Override
        public Boolean apply(BalanceGameChallenge balanceGameChallenge, List<BalanceGameChallenge> list) {
            return BalanceGameChallengeFactory.usesUniqueFixedMasses(balanceGameChallenge, list);
        }
    };
    private static final Function2<BalanceGameChallenge, List<BalanceGameChallenge>, Boolean> UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST = new Function2<BalanceGameChallenge, List<BalanceGameChallenge>, Boolean>(){

        @Override
        public Boolean apply(BalanceGameChallenge balanceGameChallenge, List<BalanceGameChallenge> list) {
            return BalanceGameChallengeFactory.usesUniqueFixedMassesAndDistances(balanceGameChallenge, list);
        }
    };

    private BalanceGameChallengeFactory() {
    }

    public static List<BalanceGameChallenge> generateChallengeSet(int n) {
        ArrayList<BalanceGameChallenge> arrayList = new ArrayList<BalanceGameChallenge>();
        if (n == 1) {
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(SIMPLE_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(SIMPLE_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(SIMPLE_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_TEST, USED_MASS_DEDUCTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(SIMPLE_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_TEST, USED_MASS_DEDUCTION_CHALLENGES));
        } else if (n == 2) {
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_TEST, USED_MASS_DEDUCTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_TEST, USED_MASS_DEDUCTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
        } else if (n == 3) {
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(EASY_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_TEST, USED_MASS_DEDUCTION_CHALLENGES));
        } else if (n == 4) {
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(ADVANCED_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(ADVANCED_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_TEST, USED_MASS_DEDUCTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(ADVANCED_TILT_PREDICTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_AND_DISTANCES_TEST, USED_TILT_PREDICTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(MODERATE_MASS_DEDUCTION_CHALLENGE_GENERATOR, UNIQUE_FIXED_MASSES_TEST, USED_MASS_DEDUCTION_CHALLENGES));
            arrayList.add(BalanceGameChallengeFactory.generateUniqueChallenge(ADVANCED_BALANCE_CHALLENGE_GENERATOR, UNIQUE_MASSES_TEST, USED_BALANCE_CHALLENGES));
        } else {
            throw new IllegalArgumentException("Challenge level invalid, value = " + n);
        }
        assert (arrayList.size() == 6);
        return arrayList;
    }

    private static BalanceMassesChallenge generateSimpleBalanceChallenge() {
        int n = 1 + RAND.nextInt(4);
        double d = -BalanceGameChallengeFactory.generateRandomValidPlankDistance();
        return BalanceGameChallengeFactory.createTwoBrickStackChallenge(n, d, n);
    }

    private static BalanceMassesChallenge generateEasyBalanceChallenge() {
        int n = 1;
        int n2 = 1;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (arrayList.size() == 0) {
            n = (int)Math.pow(2.0, RAND.nextInt(3));
            n2 = n == 1 || RAND.nextBoolean() ? 2 * n : n / 2;
            arrayList.addAll(BalanceGameChallengeFactory.getPossibleDistanceList((double)n * 5.0, (double)n2 * 5.0));
        }
        double d = -((Double)arrayList.get(RAND.nextInt(arrayList.size()))).doubleValue();
        return BalanceGameChallengeFactory.createTwoBrickStackChallenge(n, d, n2);
    }

    private static BalanceMassesChallenge generateModerateBalanceChallenge() {
        Mass mass;
        Mass mass2;
        do {
            if ((mass = BalanceGameChallengeFactory.createMassByRatio((mass2 = BALANCE_CHALLENGE_MASSES.get(RAND.nextInt(BALANCE_CHALLENGE_MASSES.size()))).getMass(), 3.0, 0.3333333333333333, 1.5, 0.6666666666666666, 4.0, 0.25)) == null) assert (false);
        } while (!BalanceGameChallengeFactory.isChallengeSolvable(mass2.getMass(), mass.getMass(), 0.25, MAX_DISTANCE_FROM_BALANCE_CENTER_TO_MASS));
        double d = BalanceGameChallengeFactory.chooseRandomValidFixedMassDistance(mass2.getMass(), mass.getMass());
        return BalanceMassesChallenge.create(mass2.createCopy(), d, mass);
    }

    private static BalanceGameChallenge generateMultiMassBalanceChallenge() {
        Mass mass;
        Mass mass2;
        Mass mass3;
        List<BalanceGameChallenge> list;
        while ((list = BalanceGameChallengeFactory.generateSolvableChallenges(mass3 = BALANCE_CHALLENGE_MASSES.get(RAND.nextInt(BALANCE_CHALLENGE_MASSES.size())), mass2 = BALANCE_CHALLENGE_MASSES.get(RAND.nextInt(BALANCE_CHALLENGE_MASSES.size())), mass = BALANCE_CHALLENGE_MASSES.get(RAND.nextInt(BALANCE_CHALLENGE_MASSES.size())), 0.25, 2.0)).size() == 0) {
        }
        return list.get(RAND.nextInt(list.size()));
    }

    private static BalanceMassesChallenge createTwoBrickStackChallenge(int n, double d, int n2) {
        return BalanceMassesChallenge.create(new BrickStack(n), d, new BrickStack(n2));
    }

    private static double chooseRandomValidFixedMassDistance(double d, double d2) {
        List<Double> list = BalanceGameChallengeFactory.getPossibleDistanceList(d, d2);
        return -list.get(RAND.nextInt(list.size())).doubleValue();
    }

    private static List<Double> getPossibleDistanceList(double d, double d2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d3 = 0.25; d3 < Plank.getLength() / 2.0; d3 += 0.25) {
            double d4 = d3 * d2 / d;
            if (!(d4 < Plank.getLength() / 2.0) || !(d4 >= 0.249999) || !(d4 % 0.25 < 1.0E-6)) continue;
            arrayList.add(d4);
        }
        return arrayList;
    }

    private static double generateRandomValidPlankDistance() {
        double d = Plank.getLength() / 2.0;
        double d2 = 0.25;
        int n = (int)Math.round(d / d2) - 1;
        return (double)(RAND.nextInt(n) + 1) * d2;
    }

    private static double generateRandomValidPlankDistance(double d, double d2) {
        int n = (int)Math.ceil(d / 0.25);
        int n2 = (int)Math.floor(d2 / 0.25);
        assert (n2 > n);
        return (double)(RAND.nextInt(n2 - n + 1) + n) * 0.25;
    }

    private static MassDeductionChallenge generateSimpleMassDeductionChallenge() {
        int n = RAND.nextInt(BALANCE_CHALLENGE_MASSES.size());
        Mass mass = null;
        Mass mass2 = null;
        for (int i = 0; i < MYSTERY_MASSES.size() && mass == null; ++i) {
            mass2 = MYSTERY_MASSES.get((i + n) % MYSTERY_MASSES.size());
            mass = BalanceGameChallengeFactory.createMassByRatio(mass2.getMass(), 1.0);
        }
        assert (mass != null);
        double d = -BalanceGameChallengeFactory.generateRandomValidPlankDistance();
        return MassDeductionChallenge.create(mass2.createCopy(), d, mass);
    }

    private static TiltPredictionChallenge generateSimpleTiltPredictionChallenge() {
        int n;
        int n2 = n = RAND.nextInt(4) + 1;
        while (n2 == n) {
            n2 = RAND.nextInt(4) + 1;
        }
        double d = BalanceGameChallengeFactory.generateRandomValidPlankDistance(0.25, 1.5);
        return TiltPredictionChallenge.create(new BrickStack(n), d, new BrickStack(n2), -d);
    }

    private static TiltPredictionChallenge generateEasyTiltPredictionChallenge() {
        int n;
        int n2 = n = RAND.nextInt(4) + 1;
        double d = BalanceGameChallengeFactory.generateRandomValidPlankDistance(0.25, 1.5);
        double d2 = -d;
        if (RAND.nextDouble() > 0.2) {
            d2 = -BalanceGameChallengeFactory.generateRandomValidPlankDistance(0.25, 1.5);
        }
        return TiltPredictionChallenge.create(new BrickStack(n), d, new BrickStack(n2), d2);
    }

    private static TiltPredictionChallenge generateModerateTiltPredictionChallenge() {
        Object object;
        Mass mass = LOW_PROFILE_MASSES.get(RAND.nextInt(LOW_PROFILE_MASSES.size())).createCopy();
        Mass mass2 = new BrickStack(RAND.nextInt(4) + 1);
        if (RAND.nextBoolean()) {
            object = mass;
            mass = mass2;
            mass2 = object;
        }
        object = BalanceGameChallengeFactory.positionMassesCloseToBalancing(0.25, 1.75, mass, mass2);
        return new TiltPredictionChallenge((List<MassDistancePair>)object);
    }

    private static TiltPredictionChallenge generateAdvancedTiltPredictionChallenge() {
        Mass mass = LOW_PROFILE_MASSES.get(RAND.nextInt(LOW_PROFILE_MASSES.size())).createCopy();
        Mass mass2 = LOW_PROFILE_MASSES.get(RAND.nextInt(LOW_PROFILE_MASSES.size())).createCopy();
        BrickStack brickStack = new BrickStack(RAND.nextInt(4) + 1);
        List<MassDistancePair> list = BalanceGameChallengeFactory.positionMassesCloseToBalancing(0.25, 2.0, mass, mass2, brickStack);
        return new TiltPredictionChallenge(list);
    }

    private static List<MassDistancePair> positionMassesCloseToBalancing(double d, double d2, Mass ... massArray) {
        ArrayList<Double> arrayList;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = 1.0;
        ArrayList<Double> arrayList2 = arrayList = new ArrayList<Double>();
        for (int i = 0; i < 50; ++i) {
            int n;
            arrayList.clear();
            for (n = 0; arrayList.size() < massArray.length && n < 50; ++n) {
                double d5 = BalanceGameChallengeFactory.generateRandomValidPlankDistance(d, d2);
                if (n == 0) {
                    d5 = RAND.nextBoolean() ? -d5 : d5;
                } else {
                    double d6 = d5 = (Double)arrayList.get(arrayList.size() - 1) > 0.0 ? -d5 : d5;
                }
                if (arrayList.contains(d5)) continue;
                arrayList.add(d5);
            }
            if (arrayList.size() != massArray.length) {
                arrayList.clear();
                for (n = 0; n < massArray.length; ++n) {
                    arrayList.add(d + 0.25 * (double)n);
                    System.out.println(" Warning: Unable to find enough unique distances for positioning masses.");
                }
            }
            double d7 = 0.0;
            for (int j = 0; j < massArray.length; ++j) {
                d7 += massArray[j].getMass() * (Double)arrayList.get(j);
            }
            if (!((d7 = Math.abs(d7)) < d3) || !(d7 > d4)) continue;
            d3 = d7;
            arrayList2 = new ArrayList(arrayList);
        }
        ArrayList<MassDistancePair> arrayList3 = new ArrayList<MassDistancePair>();
        for (int i = 0; i < massArray.length; ++i) {
            arrayList3.add(new MassDistancePair(massArray[i], (Double)arrayList2.get(i)));
        }
        return arrayList3;
    }

    private static MassDeductionChallenge generateEasyMassDeductionChallenge() {
        int n = RAND.nextInt(BALANCE_CHALLENGE_MASSES.size());
        Mass mass = null;
        Mass mass2 = null;
        for (int i = 0; i < MYSTERY_MASSES.size() && mass == null; ++i) {
            mass2 = MYSTERY_MASSES.get((i + n) % MYSTERY_MASSES.size());
            mass = BalanceGameChallengeFactory.createMassByRatio(mass2.getMass(), 2.0, 0.5);
        }
        assert (mass != null);
        List<Double> list = BalanceGameChallengeFactory.getPossibleDistanceList(mass2.getMass(), mass.getMass());
        double d = -list.get(RAND.nextInt(list.size())).doubleValue();
        return MassDeductionChallenge.create(mass2.createCopy(), d, mass);
    }

    private static MassDeductionChallenge generateModerateMassDeductionChallenge() {
        int n = RAND.nextInt(BALANCE_CHALLENGE_MASSES.size());
        Mass mass = null;
        Mass mass2 = null;
        for (int i = 0; i < MYSTERY_MASSES.size() && mass == null; ++i) {
            mass2 = MYSTERY_MASSES.get((i + n) % MYSTERY_MASSES.size());
            mass = BalanceGameChallengeFactory.createMassByRatio(mass2.getMass(), 1.5, 3.0, 0.3333333333333333, 0.6666666666666666, 4.0, 0.25);
        }
        assert (mass != null);
        List<Double> list = BalanceGameChallengeFactory.getPossibleDistanceList(mass2.getMass(), mass.getMass());
        double d = -list.get(RAND.nextInt(list.size())).doubleValue();
        return MassDeductionChallenge.create(mass2.createCopy(), d, mass);
    }

    private static Mass createMassByRatio(double d, double ... dArray) {
        int n = RAND.nextInt(BALANCE_CHALLENGE_MASSES.size());
        for (int i = 0; i < BALANCE_CHALLENGE_MASSES.size(); ++i) {
            Mass mass = BALANCE_CHALLENGE_MASSES.get((i + n) % BALANCE_CHALLENGE_MASSES.size());
            double[] dArray2 = dArray;
            int n2 = dArray2.length;
            for (int j = 0; j < n2; ++j) {
                Double d2 = dArray2[j];
                if (mass.getMass() * d2 != d) continue;
                return mass.createCopy();
            }
        }
        return null;
    }

    private static BalanceGameChallenge generateUniqueChallenge(Function0<BalanceGameChallenge> function0, Function2<BalanceGameChallenge, List<BalanceGameChallenge>, Boolean> function2, List<BalanceGameChallenge> list) {
        BalanceGameChallenge balanceGameChallenge = null;
        boolean bl = false;
        for (int i = 0; i < 3 && !bl; ++i) {
            for (int j = 0; j < 50; ++j) {
                balanceGameChallenge = function0.apply();
                if (!function2.apply(balanceGameChallenge, list).booleanValue()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            BalanceGameChallengeFactory.removeOldestHalfOfList(list);
        }
        list.add(balanceGameChallenge);
        return balanceGameChallenge;
    }

    private static boolean isChallengeSolvable(double d, double d2, double d3, double d4) {
        if (d * d3 > d2 * d4 || d * d4 < d2 * d3) {
            return false;
        }
        return d / d2 % d3 <= 1.0E-6;
    }

    private static List<BalanceGameChallenge> generateSolvableChallenges(Mass mass, Mass mass2, Mass mass3, double d, double d2) {
        ArrayList<BalanceGameChallenge> arrayList = new ArrayList<BalanceGameChallenge>();
        for (double d3 = d; d3 <= d2; d3 += d) {
            for (double d4 = d; d4 <= d2; d4 += d) {
                double d5;
                double d6;
                if (d3 == d4 || Math.abs(d3 - d4) < 1.1 * d || !((d6 = (d5 = mass.getMass() * d3 + mass2.getMass() * d4) / mass3.getMass()) >= d) || !(d6 <= d2) || d6 % d != 0.0) continue;
                arrayList.add(BalanceMassesChallenge.create(mass.createCopy(), d3, mass2.createCopy(), d4, mass3.createCopy()));
            }
        }
        return arrayList;
    }

    private static boolean usesUniqueMasses(BalanceGameChallenge balanceGameChallenge, List<BalanceGameChallenge> list) {
        for (BalanceGameChallenge balanceGameChallenge2 : list) {
            if (!balanceGameChallenge2.usesSameMasses(balanceGameChallenge)) continue;
            return false;
        }
        return true;
    }

    private static boolean usesUniqueFixedMasses(BalanceGameChallenge balanceGameChallenge, List<BalanceGameChallenge> list) {
        for (BalanceGameChallenge balanceGameChallenge2 : list) {
            if (!balanceGameChallenge2.usesSameFixedMasses(balanceGameChallenge)) continue;
            return false;
        }
        return true;
    }

    private static boolean usesUniqueFixedMassesAndDistances(BalanceGameChallenge balanceGameChallenge, List<BalanceGameChallenge> list) {
        for (BalanceGameChallenge balanceGameChallenge2 : list) {
            if (!balanceGameChallenge2.usesSameFixedMassesAndDistances(balanceGameChallenge)) continue;
            return false;
        }
        return true;
    }

    private static void removeOldestHalfOfList(List list) {
        int n = list.size() / 2;
        for (int i = 0; i < n; ++i) {
            list.remove(0);
        }
    }
}

