/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.model;

import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.game.model.ChallengeViewConfig;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelComponentType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BalanceGameChallenge {
    public final List<MassDistancePair> fixedMassDistancePairs = new ArrayList<MassDistancePair>();
    public final List<Mass> movableMasses = new ArrayList<Mass>();
    public final List<MassDistancePair> balancedConfiguration = new ArrayList<MassDistancePair>();
    public final ColumnState initialColumnState;
    public final int maxAttemptsAllowed;

    public BalanceGameChallenge(ColumnState columnState) {
        this(columnState, 2);
    }

    public BalanceGameChallenge(ColumnState columnState, int n) {
        this.initialColumnState = columnState;
        this.maxAttemptsAllowed = n;
    }

    public boolean usesSameMasses(BalanceGameChallenge balanceGameChallenge) {
        return this.usesSameFixedMasses(balanceGameChallenge) && this.usesSameMovableMasses(balanceGameChallenge);
    }

    public boolean usesSameFixedMasses(BalanceGameChallenge balanceGameChallenge) {
        List<Mass> list;
        if (this == balanceGameChallenge) {
            return true;
        }
        List<Mass> list2 = this.getFixedMassList();
        return this.containsEquivalentMasses(list2, list = balanceGameChallenge.getFixedMassList());
    }

    public boolean usesSameFixedMassesAndDistances(BalanceGameChallenge balanceGameChallenge) {
        if (this == balanceGameChallenge) {
            return true;
        }
        if (this.fixedMassDistancePairs.size() != balanceGameChallenge.fixedMassDistancePairs.size()) {
            return false;
        }
        int n = 0;
        for (MassDistancePair massDistancePair : this.fixedMassDistancePairs) {
            for (MassDistancePair massDistancePair2 : balanceGameChallenge.fixedMassDistancePairs) {
                if (massDistancePair.mass.getMass() != massDistancePair2.mass.getMass() || massDistancePair.distance != massDistancePair2.distance) continue;
                ++n;
            }
        }
        return n == this.fixedMassDistancePairs.size();
    }

    public boolean usesSameMovableMasses(BalanceGameChallenge balanceGameChallenge) {
        return this.containsEquivalentMasses(this.movableMasses, balanceGameChallenge.movableMasses);
    }

    private boolean containsEquivalentMass(Mass mass, List<Mass> list) {
        for (Mass mass2 : list) {
            if (mass.getMass() != mass2.getMass() || mass.getClass() != mass2.getClass()) continue;
            return true;
        }
        return false;
    }

    private boolean containsEquivalentMasses(List<Mass> list, List<Mass> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (Mass mass : list) {
            if (this.containsEquivalentMass(mass, list2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BalanceGameChallenge balanceGameChallenge = (BalanceGameChallenge)object;
        for (MassDistancePair object2 : this.fixedMassDistancePairs) {
            if (balanceGameChallenge.fixedMassDistancePairs.contains(object2)) continue;
            return false;
        }
        if (this.movableMasses.size() != balanceGameChallenge.movableMasses.size()) {
            return false;
        }
        ArrayList<Mass> arrayList = new ArrayList<Mass>(balanceGameChallenge.movableMasses);
        block1: for (Mass mass : this.movableMasses) {
            for (Mass mass2 : new ArrayList(arrayList)) {
                if (mass.getMass() != mass2.getMass() || !arrayList.contains(mass2)) continue;
                arrayList.remove(mass2);
                continue block1;
            }
        }
        if (arrayList.size() != 0) {
            return false;
        }
        return this.balancedConfiguration.equals(balanceGameChallenge.balancedConfiguration);
    }

    public abstract ChallengeViewConfig getChallengeViewConfig();

    public List<Mass> getFixedMassList() {
        ArrayList<Mass> arrayList = new ArrayList<Mass>();
        for (MassDistancePair massDistancePair : this.fixedMassDistancePairs) {
            arrayList.add(massDistancePair.mass);
        }
        return arrayList;
    }

    public double getFixedMassValueTotal() {
        double d = 0.0;
        for (MassDistancePair massDistancePair : this.fixedMassDistancePairs) {
            d += massDistancePair.mass.getMass();
        }
        return d;
    }

    public abstract IModelComponentType getModelComponentType();

    public abstract String getCorrectAnswerString();
}

