/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.Plank;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.view.ModelObjectNode;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PlankNode
extends ModelObjectNode {
    private static final Stroke NORMAL_TICK_MARK_STROKE = new BasicStroke(1.0f, 0, 0);
    private static final Stroke NORMAL_HIGHLIGHT_STROKE = new BasicStroke(11.0f, 0, 0);
    private static final Stroke BOLD_TICK_MARK_STROKE = new BasicStroke(3.0f, 0, 0);
    private static final Stroke BOLD_HIGHLIGHT_STROKE = new BasicStroke(11.0f, 0, 0);
    private static final Color HIGHLIGHT_COLOR = Color.WHITE;
    private ModelViewTransform mvt;
    private Plank plank;
    private PhetPCanvas canvas;

    public PlankNode(final ModelViewTransform modelViewTransform, final Plank plank, PhetPCanvas phetPCanvas) {
        super(modelViewTransform, plank, new Color(243, 203, 127));
        this.mvt = modelViewTransform;
        this.plank = plank;
        this.canvas = phetPCanvas;
        final PNode pNode = new PNode();
        this.addChild(pNode);
        plank.addShapeObserver(new VoidFunction1<Shape>(){

            @Override
            public void apply(Shape shape) {
                PlankNode.this.updateTickMarks(pNode, plank, modelViewTransform);
            }
        });
        plank.massesOnSurface.addElementAddedObserver(new VoidFunction1<Mass>(){

            @Override
            public void apply(Mass mass) {
                PlankNode.this.updateTickMarks(pNode, plank, modelViewTransform);
            }
        });
        plank.massesOnSurface.addElementRemovedObserver(new VoidFunction1<Mass>(){

            @Override
            public void apply(Mass mass) {
                PlankNode.this.updateTickMarks(pNode, plank, modelViewTransform);
            }
        });
        if (plank.getTiltAngle() == 0.0) {
            this.addTiltHandles();
        }
    }

    private void addTiltHandles() {
        PNode pNode = new PNode();
        this.addChild(pNode);
        Color color = new Color(255, 255, 255, 0);
        Rectangle2D rectangle2D = this.plank.getShape().getBounds2D();
        final PhetPPath phetPPath = new PhetPPath((Shape)new Rectangle2D.Double(this.mvt.modelToViewDeltaX(rectangle2D.getWidth() / 6.0), -this.mvt.modelToViewDeltaY(rectangle2D.getHeight()), this.mvt.modelToViewDeltaX(rectangle2D.getWidth() / 3.0), -this.mvt.modelToViewDeltaY(rectangle2D.getHeight())), color);
        phetPPath.setOffset(this.mvt.modelToView(this.plank.getPivotPoint()));
        phetPPath.addInputEventListener(new CursorHandler(8));
        pNode.addChild(phetPPath);
        final PhetPPath phetPPath2 = new PhetPPath((Shape)new Rectangle2D.Double(-this.mvt.modelToViewDeltaX(rectangle2D.getWidth() / 2.0), -this.mvt.modelToViewDeltaY(rectangle2D.getHeight()), this.mvt.modelToViewDeltaX(rectangle2D.getWidth() / 3.0), -this.mvt.modelToViewDeltaY(rectangle2D.getHeight())), color);
        phetPPath2.setOffset(this.mvt.modelToView(this.plank.getPivotPoint()));
        phetPPath2.addInputEventListener(new CursorHandler(8));
        pNode.addChild(phetPPath2);
        this.plank.addShapeObserver(new VoidFunction1<Shape>(){

            @Override
            public void apply(Shape shape) {
                phetPPath.setRotation(-PlankNode.this.plank.getTiltAngle());
                phetPPath2.setRotation(-PlankNode.this.plank.getTiltAngle());
            }
        });
        phetPPath.addInputEventListener(new TiltHandleDragHandler(this.plank, this.canvas, this.mvt));
        phetPPath2.addInputEventListener(new TiltHandleDragHandler(this.plank, this.canvas, this.mvt));
    }

    private void updateTickMarks(PNode pNode, Plank plank, ModelViewTransform modelViewTransform) {
        pNode.removeAllChildren();
        for (int i = 0; i < plank.getTickMarks().size(); ++i) {
            Stroke stroke = NORMAL_TICK_MARK_STROKE;
            Stroke stroke2 = NORMAL_HIGHLIGHT_STROKE;
            if (i % 2 == 0) {
                stroke = BOLD_TICK_MARK_STROKE;
                stroke2 = BOLD_HIGHLIGHT_STROKE;
            }
            if (plank.isTickMarkOccupied(plank.getTickMarks().get(i))) {
                pNode.addChild(new PhetPPath(modelViewTransform.modelToView(plank.getTickMarks().get(i)), stroke2, (Paint)HIGHLIGHT_COLOR));
            }
            pNode.addChild(new PhetPPath(modelViewTransform.modelToView(plank.getTickMarks().get(i)), stroke, (Paint)Color.BLACK));
        }
    }

    private static class TiltHandleDragHandler
    extends PDragEventHandler {
        private final Plank plank;
        private final ModelViewTransform mvt;
        private final PhetPCanvas canvas;
        private double dragAngleDelta;

        public TiltHandleDragHandler(Plank plank, PhetPCanvas phetPCanvas, ModelViewTransform modelViewTransform) {
            this.plank = plank;
            this.canvas = phetPCanvas;
            this.mvt = modelViewTransform;
        }

        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            this.plank.userControlled.set(true);
            this.dragAngleDelta = this.plank.getTiltAngle() - this.getMouseToPlankCenterAngle(pInputEvent.getCanvasPosition());
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            this.plank.setTiltAngle(this.getMouseToPlankCenterAngle(pInputEvent.getCanvasPosition()) + this.dragAngleDelta);
            SimSharingManager.sendUserMessage(BalanceAndTorqueSimSharing.ModelComponents.plank, UserComponentTypes.sprite, UserActions.drag, new ParameterSet(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.plankTiltAngle, this.plank.getTiltAngle())));
        }

        protected void endDrag(PInputEvent pInputEvent) {
            super.endDrag(pInputEvent);
            this.plank.userControlled.set(false);
        }

        private Point2D getModelPosition(Point2D point2D) {
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
            this.canvas.getPhetRootNode().screenToWorld(double_);
            return this.mvt.viewToModel(double_);
        }

        double getMouseToPlankCenterAngle(Point2D point2D) {
            Point2D point2D2 = this.getModelPosition(point2D);
            MutableVector2D mutableVector2D = new MutableVector2D(point2D2.getX() - this.plank.getPlankSurfaceCenter().getX(), point2D2.getY() - this.plank.getPlankSurfaceCenter().getY());
            if (Math.abs(mutableVector2D.getAngle()) > 1.5707963267948966) {
                mutableVector2D.rotate(Math.PI);
            }
            return mutableVector2D.getAngle();
        }
    }
}

