/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.view;

import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public class MassDragHandler
extends SimSharingDragHandler {
    private final Mass mass;
    private final PNode node;
    private final ModelViewTransform mvt;
    private final PhetPCanvas canvas;

    public MassDragHandler(Mass mass, PNode pNode, PhetPCanvas phetPCanvas, ModelViewTransform modelViewTransform) {
        super(mass.getUserComponent(), UserComponentTypes.sprite, false);
        this.mass = mass;
        this.node = pNode;
        this.canvas = phetPCanvas;
        this.mvt = modelViewTransform;
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        this.mass.userControlled.set(true);
        Point2D point2D = this.getModelPosition(pInputEvent.getCanvasPosition());
        double d = this.mass.getMiddlePoint().getY() - this.mass.getPosition().getY();
        this.mass.setPosition(point2D.getX(), point2D.getY() - d);
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        super.mouseDragged(pInputEvent);
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(this.node.getParent());
        Vector2D vector2D = this.mvt.viewToModelDelta(new Vector2D(pDimension));
        this.mass.translate(vector2D);
    }

    protected void endDrag(PInputEvent pInputEvent) {
        super.endDrag(pInputEvent);
        this.mass.userControlled.set(false);
    }

    private Point2D getModelPosition(Point2D point2D) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        this.canvas.getPhetRootNode().screenToWorld(double_);
        return this.mvt.viewToModel(double_);
    }
}

