/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.LevelSupportColumn;
import edu.colorado.phet.balanceandtorque.common.view.ModelObjectNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJButton;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelSupportColumnNode
extends ModelObjectNode {
    private static final Color BASE_COLOR = new Color(153, 102, 204);

    public LevelSupportColumnNode(final ModelViewTransform modelViewTransform, final LevelSupportColumn levelSupportColumn, final Property<ColumnState> property, boolean bl) {
        super(modelViewTransform, levelSupportColumn, new GradientPaint((float)modelViewTransform.modelToViewX(levelSupportColumn.getShape().getBounds2D().getMinX()), 0.0f, ColorUtils.brighterColor(BASE_COLOR, 0.7), (float)modelViewTransform.modelToViewX(levelSupportColumn.getShape().getBounds2D().getMaxX()), 0.0f, ColorUtils.darkerColor(BASE_COLOR, 0.6)));
        property.addObserver(new VoidFunction1<ColumnState>(){

            @Override
            public void apply(ColumnState columnState) {
                LevelSupportColumnNode.this.setVisible(columnState == ColumnState.DOUBLE_COLUMNS);
            }
        });
        if (bl) {
            PSwing pSwing = new PSwing(new SimSharingCloseButton()){
                {
                    super(jComponent);
                    this.setScale(0.8);
                    double d = modelViewTransform.modelToViewX(levelSupportColumn.getShape().getBounds2D().getCenterX()) - this.getFullBoundsReference().width / 2.0;
                    double d2 = modelViewTransform.modelToViewY(levelSupportColumn.getShape().getBounds2D().getMinY()) - 2.0 * this.getFullBoundsReference().height;
                    this.setOffset(d, d2);
                    this.addInputEventListener(new CursorHandler());
                    this.addInputEventListener(new ButtonEventHandler(){

                        public void mouseReleased(PInputEvent pInputEvent) {
                            property.set(ColumnState.NONE);
                        }
                    });
                }
            };
            this.addChild(pSwing);
        }
    }

    private static class SimSharingCloseButton
    extends SimSharingJButton {
        private SimSharingCloseButton() {
            super(BalanceAndTorqueSimSharing.UserComponents.redXRemoveSupportsButton);
            BufferedImage bufferedImage = PhetCommonResources.getInstance().getImage("buttons/closeButton.png");
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            this.setIcon(imageIcon);
            this.setOpaque(false);
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }
}

