/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.balancelab.view.AttachmentBarNode;
import edu.colorado.phet.balanceandtorque.balancelab.view.MysteryVectorNode;
import edu.colorado.phet.balanceandtorque.balancelab.view.PositionedVectorNode;
import edu.colorado.phet.balanceandtorque.common.model.BalanceModel;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.LevelSupportColumn;
import edu.colorado.phet.balanceandtorque.common.model.Plank;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.view.FulcrumAbovePlankNode;
import edu.colorado.phet.balanceandtorque.common.view.LevelIndicatorNode;
import edu.colorado.phet.balanceandtorque.common.view.LevelSupportColumnNode;
import edu.colorado.phet.balanceandtorque.common.view.MassNodeFactory;
import edu.colorado.phet.balanceandtorque.common.view.PlankNode;
import edu.colorado.phet.balanceandtorque.common.view.RotatingRulerNode;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.background.OutsideBackgroundNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.swing.SwingLayoutNode;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.geom.Point2D;

public abstract class BasicBalanceCanvas
extends PhetPCanvas
implements Resettable {
    protected final ModelViewTransform mvt;
    public final BooleanProperty massLabelVisibilityProperty = new BooleanProperty(true);
    public final BooleanProperty distancesVisibleProperty = new BooleanProperty(false);
    public final BooleanProperty forceVectorsFromObjectsVisibleProperty = new BooleanProperty(false);
    public final BooleanProperty levelIndicatorVisibleProperty = new BooleanProperty(false);
    protected PNode nonMassLayer;
    protected PNode controlPanel;

    public BasicBalanceCanvas(final BalanceModel balanceModel) {
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() * 0.4), (int)Math.round(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getHeight() * 0.75)), 150.0);
        PNode pNode = new PNode();
        this.addWorldChild(pNode);
        pNode.addChild(new OutsideBackgroundNode(this.mvt, 3.0, 1.0));
        this.nonMassLayer = new PNode();
        pNode.addChild(this.nonMassLayer);
        final PNode pNode2 = new PNode();
        pNode.addChild(pNode2);
        balanceModel.massList.addElementAddedObserver(new VoidFunction1<Mass>(){

            @Override
            public void apply(final Mass mass) {
                PNode pNode = MassNodeFactory.createMassNode(mass, BasicBalanceCanvas.this.massLabelVisibilityProperty, BasicBalanceCanvas.this.mvt, BasicBalanceCanvas.this);
                pNode2.addChild(pNode);
                final PNode pNode22 = pNode;
                balanceModel.massList.addElementRemovedObserver(mass, new VoidFunction0(){

                    public void apply() {
                        pNode2.removeChild(pNode22);
                        SimSharingManager.sendUserMessage(mass.getUserComponent(), mass.getUserComponentType(), BalanceAndTorqueSimSharing.UserActions.removedMass);
                    }
                });
            }
        });
        this.nonMassLayer.addChild(new FulcrumAbovePlankNode(this.mvt, balanceModel.getFulcrum()));
        this.nonMassLayer.addChild(new PlankNode(this.mvt, balanceModel.getPlank(), this));
        this.nonMassLayer.addChild(new AttachmentBarNode(this.mvt, balanceModel.getAttachmentBar()));
        for (LevelSupportColumn object2 : balanceModel.getSupportColumns()) {
            this.nonMassLayer.addChild(new LevelSupportColumnNode(this.mvt, object2, balanceModel.columnState, true));
        }
        this.nonMassLayer.addChild(new RotatingRulerNode(balanceModel.getPlank(), this.mvt, this.distancesVisibleProperty));
        this.nonMassLayer.addChild(new LevelIndicatorNode(this.mvt, balanceModel.getPlank()){
            {
                BasicBalanceCanvas.this.levelIndicatorVisibleProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
            }
        });
        balanceModel.getPlank().forceVectorList.addElementAddedObserver(new VoidFunction1<Plank.MassForceVector>(){

            @Override
            public void apply(final Plank.MassForceVector massForceVector) {
                final PNode pNode = massForceVector.isObfuscated() ? new MysteryVectorNode(massForceVector.forceVectorProperty, BasicBalanceCanvas.this.forceVectorsFromObjectsVisibleProperty, BasicBalanceCanvas.this.mvt) : new PositionedVectorNode(massForceVector.forceVectorProperty, 0.002, BasicBalanceCanvas.this.forceVectorsFromObjectsVisibleProperty, Color.WHITE, BasicBalanceCanvas.this.mvt);
                BasicBalanceCanvas.this.nonMassLayer.addChild(pNode);
                balanceModel.getPlank().forceVectorList.addElementRemovedObserver(new VoidFunction1<Plank.MassForceVector>(){

                    @Override
                    public void apply(Plank.MassForceVector massForceVector2) {
                        if (massForceVector2 == massForceVector) {
                            BasicBalanceCanvas.this.nonMassLayer.removeChild(pNode);
                        }
                    }
                });
            }
        });
        final TextButtonNode textButtonNode = new TextButtonNode(BalanceAndTorqueResources.Strings.ADD_SUPPORTS, new PhetFont(14)){
            {
                super(string, font);
                this.setUserComponent(BalanceAndTorqueSimSharing.UserComponents.addSupportsButton);
                this.setBackground(Color.YELLOW);
                this.addInputEventListener(new ButtonEventHandler(){

                    public void mouseReleased(PInputEvent pInputEvent) {
                        balanceModel.columnState.set(ColumnState.DOUBLE_COLUMNS);
                    }
                });
                Point2D.Double double_ = new Point2D.Double(BasicBalanceCanvas.this.mvt.modelToViewX(2.55), BasicBalanceCanvas.this.mvt.modelToViewY(-0.3));
                this.centerFullBoundsOnPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
            }
        };
        this.nonMassLayer.addChild(textButtonNode);
        final TextButtonNode textButtonNode2 = new TextButtonNode(BalanceAndTorqueResources.Strings.REMOVE_SUPPORTS, new PhetFont(14)){
            {
                super(string, font);
                this.setUserComponent(BalanceAndTorqueSimSharing.UserComponents.removeSupportsButton);
                this.setBackground(Color.YELLOW);
                this.addInputEventListener(new ButtonEventHandler(){

                    public void mouseReleased(PInputEvent pInputEvent) {
                        balanceModel.columnState.set(ColumnState.NONE);
                    }
                });
                this.centerFullBoundsOnPoint(textButtonNode.getFullBoundsReference().getCenterX(), textButtonNode.getFullBoundsReference().getCenterY());
            }
        };
        this.nonMassLayer.addChild(textButtonNode2);
        balanceModel.columnState.addObserver(new VoidFunction1<ColumnState>(){

            @Override
            public void apply(ColumnState columnState) {
                textButtonNode.setVisible(columnState == ColumnState.NONE);
                textButtonNode2.setVisible(columnState == ColumnState.DOUBLE_COLUMNS);
            }
        });
        this.controlPanel = new ControlPanelNode((PNode)new SwingLayoutNode(new GridLayout(5, 1)){
            {
                this.addChild(new PText(BalanceAndTorqueResources.Strings.SHOW){
                    {
                        this.setFont(new PhetFont(18));
                    }
                });
                this.addChild(new PropertyCheckBoxNode(BalanceAndTorqueSimSharing.UserComponents.massLabelsCheckBox, BalanceAndTorqueResources.Strings.MASS_LABELS, BasicBalanceCanvas.this.massLabelVisibilityProperty));
                this.addChild(new PropertyCheckBoxNode(BalanceAndTorqueSimSharing.UserComponents.rulersCheckBox, BalanceAndTorqueResources.Strings.RULERS, BasicBalanceCanvas.this.distancesVisibleProperty));
                this.addChild(new PropertyCheckBoxNode(BalanceAndTorqueSimSharing.UserComponents.forceFromObjectsCheckBox, BalanceAndTorqueResources.Strings.FORCES_FROM_OBJECTS, BasicBalanceCanvas.this.forceVectorsFromObjectsVisibleProperty));
                this.addChild(new PropertyCheckBoxNode(BalanceAndTorqueSimSharing.UserComponents.levelCheckBox, BalanceAndTorqueResources.Strings.LEVEL, BasicBalanceCanvas.this.levelIndicatorVisibleProperty));
            }
        });
        this.controlPanel.setOffset(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() - this.controlPanel.getFullBoundsReference().width - 20.0, 100.0);
        this.nonMassLayer.addChild(this.controlPanel);
        Resettable[] resettableArray = new Resettable[]{this, balanceModel};
        this.nonMassLayer.addChild(new ResetAllButtonNode(resettableArray, this, 14, Color.BLACK, new Color(255, 153, 0)){
            {
                super(resettableArray, component, n, color, color2);
                this.centerFullBoundsOnPoint(textButtonNode.getFullBoundsReference().getCenterX(), textButtonNode.getFullBoundsReference().getMaxY() + 30.0);
                this.setConfirmationEnabled(false);
            }
        });
    }

    public void reset() {
        this.distancesVisibleProperty.reset();
        this.forceVectorsFromObjectsVisibleProperty.reset();
        this.massLabelVisibilityProperty.reset();
        this.levelIndicatorVisibleProperty.reset();
    }

    private static class PropertyCheckBoxNode
    extends PNode {
        private PropertyCheckBoxNode(IUserComponent iUserComponent, String string, BooleanProperty booleanProperty) {
            PropertyCheckBox propertyCheckBox = new PropertyCheckBox(iUserComponent, string, booleanProperty);
            propertyCheckBox.setFont(new PhetFont(14));
            this.addChild(new PSwing(propertyCheckBox));
        }
    }
}

