/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model.masses;

import edu.colorado.phet.balanceandtorque.common.model.UserMovableModelElement;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mass
implements UserMovableModelElement {
    protected static final Point2D DEFAULT_INITIAL_LOCATION = new Point2D.Double(0.0, 0.0);
    public final BooleanProperty userControlled = new BooleanProperty(false);
    private final double mass;
    protected final Property<Point2D> positionProperty;
    protected final Property<Double> rotationalAngleProperty = new Property<Double>(0.0);
    protected final BooleanProperty animatingProperty = new BooleanProperty(false);
    private double centerOfMassXOffset = 0.0;
    protected Point2D animationDestination = new Point2D.Double();
    protected final MutableVector2D animationMotionVector = new MutableVector2D(0.0, 0.0);
    protected double animationScale = 1.0;
    protected double expectedAnimationTime = 0.0;
    private final boolean isMystery;
    protected final IUserComponent userComponent;

    public Mass(IUserComponent iUserComponent, double d) {
        this(iUserComponent, d, DEFAULT_INITIAL_LOCATION, false);
    }

    public Mass(IUserComponent iUserComponent, double d, Point2D point2D, boolean bl) {
        this.userComponent = iUserComponent;
        this.mass = d;
        this.positionProperty = new Property<Point2D.Double>(new Point2D.Double(point2D.getX(), point2D.getY()));
        this.isMystery = bl;
    }

    public double getMass() {
        return this.mass;
    }

    public void setPosition(double d, double d2) {
        this.positionProperty.set(new Point2D.Double(d, d2));
    }

    @Override
    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.positionProperty.get().getX(), this.positionProperty.get().getY());
    }

    public void resetPosition() {
        this.positionProperty.reset();
    }

    public void translate(double d, double d2) {
        this.positionProperty.set(new Point2D.Double(this.positionProperty.get().getX() + d, this.positionProperty.get().getY() + d2));
    }

    public void translate(Vector2D vector2D) {
        this.translate(vector2D.getX(), vector2D.getY());
    }

    public void addPositionChangeObserver(VoidFunction1<Point2D> voidFunction1) {
        this.positionProperty.addObserver(voidFunction1);
    }

    public abstract Point2D getMiddlePoint();

    public double getCenterOfMassXOffset() {
        return this.centerOfMassXOffset;
    }

    public void setCenterOfMassXOffset(double d) {
        this.centerOfMassXOffset = d;
    }

    public boolean isMystery() {
        return this.isMystery;
    }

    @Override
    public IUserComponent getUserComponent() {
        return this.userComponent;
    }

    @Override
    public IUserComponentType getUserComponentType() {
        return UserComponentTypes.sprite;
    }

    public void initiateAnimation() {
        this.animatingProperty.set(true);
        this.animatingProperty.set(false);
    }

    public void addAnimationStateObserver(ChangeObserver<Boolean> changeObserver) {
        this.animatingProperty.addObserver(changeObserver);
    }

    public void removeAnimationStateObserver(ChangeObserver<Boolean> changeObserver) {
        this.animatingProperty.removeObserver(changeObserver);
    }

    public void setOnPlank(boolean bl) {
    }

    public void setRotationAngle(double d) {
        this.rotationalAngleProperty.set(d);
    }

    public double getRotationAngle() {
        return this.rotationalAngleProperty.get();
    }

    public void addRotationalAngleChangeObserver(VoidFunction1<Double> voidFunction1) {
        this.rotationalAngleProperty.addObserver(voidFunction1);
    }

    @Override
    public void release() {
        this.userControlled.set(false);
    }

    public void setAnimationDestination(double d, double d2) {
        this.animationDestination.setLocation(d, d2);
    }

    public void setAnimationDestination(Point2D point2D) {
        this.setAnimationDestination(point2D.getX(), point2D.getY());
    }

    public abstract void stepInTime(double var1);

    public abstract Mass createCopy();
}

