/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model.masses;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.ShapeMass;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class BrickStack
extends ShapeMass {
    private static final Map<Integer, Integer> instanceCountMap = new HashMap<Integer, Integer>();
    private int numBricks = 1;

    public BrickStack(int n) {
        this(n, new Point2D.Double(0.0, 0.0));
    }

    public BrickStack(int n, Point2D point2D) {
        super(BrickStack.createUserComponent(n), (double)n * 5.0, BrickStack.generateShape(n, 1.0));
        this.setPosition(point2D);
        this.numBricks = n;
    }

    private static Shape generateShape(int n, double d) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        for (int i = 0; i < n; ++i) {
            doubleGeneralPath.moveTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
            doubleGeneralPath.lineTo(((Point2D)double_).getX() + 0.1, ((Point2D)double_).getY());
            doubleGeneralPath.lineTo(((Point2D)double_).getX() + 0.1, ((Point2D)double_).getY() + 0.06666666666666667);
            doubleGeneralPath.lineTo(((Point2D)double_).getX() - 0.1, ((Point2D)double_).getY() + 0.06666666666666667);
            doubleGeneralPath.lineTo(((Point2D)double_).getX() - 0.1, ((Point2D)double_).getY());
            doubleGeneralPath.lineTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
            ((Point2D)double_).setLocation(((Point2D)double_).getX(), ((Point2D)double_).getY() + 0.06666666666666667);
        }
        return AffineTransform.getScaleInstance(d, d).createTransformedShape(doubleGeneralPath.getGeneralPath());
    }

    private static IUserComponent createUserComponent(int n) {
        UserComponentChain userComponentChain;
        if (!instanceCountMap.containsKey(n)) {
            instanceCountMap.put(n, 0);
        }
        switch (n) {
            case 1: {
                userComponentChain = UserComponentChain.chain((IUserComponent)BalanceAndTorqueSimSharing.UserComponents.singleBrick, instanceCountMap.get(n));
                break;
            }
            case 2: {
                userComponentChain = UserComponentChain.chain((IUserComponent)BalanceAndTorqueSimSharing.UserComponents.stackOfTwoBricks, instanceCountMap.get(n));
                break;
            }
            case 3: {
                userComponentChain = UserComponentChain.chain((IUserComponent)BalanceAndTorqueSimSharing.UserComponents.stackOfThreeBricks, instanceCountMap.get(n));
                break;
            }
            case 4: {
                userComponentChain = UserComponentChain.chain((IUserComponent)BalanceAndTorqueSimSharing.UserComponents.stackOfFourBricks, instanceCountMap.get(n));
                break;
            }
            case 8: {
                userComponentChain = UserComponentChain.chain((IUserComponent)BalanceAndTorqueSimSharing.UserComponents.stackOfEightBricks, instanceCountMap.get(n));
                break;
            }
            default: {
                System.out.println("Error: No user component ID for stack of requested size, numBricks = " + n);
                assert (false);
                userComponentChain = UserComponentChain.chain((IUserComponent)BalanceAndTorqueSimSharing.UserComponents.singleBrick, instanceCountMap.get(n));
            }
        }
        instanceCountMap.put(n, instanceCountMap.get(n) + 1);
        return userComponentChain;
    }

    public void initiateAnimation() {
        double d = Math.max(this.getPosition().distance(this.animationDestination) / 0.75, 3.0);
        this.expectedAnimationTime = this.getPosition().distance(this.animationDestination) / d;
        this.animationMotionVector.setComponents(d, 0.0);
        double d2 = Math.atan2(this.animationDestination.getY() - this.getPosition().getY(), this.animationDestination.getX() - this.getPosition().getX());
        this.animationMotionVector.rotate(d2);
        this.animatingProperty.set(true);
    }

    public void stepInTime(double d) {
        if (((Boolean)this.animatingProperty.get()).booleanValue()) {
            if (this.getPosition().distance(this.animationDestination) >= this.animationMotionVector.magnitude() * d) {
                this.translate(this.animationMotionVector.times(d));
                this.animationScale = Math.max(this.animationScale - d / this.expectedAnimationTime * 0.9, 0.1);
            } else {
                this.setPosition(this.animationDestination);
                this.animatingProperty.set(false);
                this.animationScale = 1.0;
            }
        }
    }

    public Mass createCopy() {
        return new BrickStack(this.numBricks, this.getPosition());
    }
}

