/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.ShapeModelElement;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.model.masses.PositionedVector;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plank
extends ShapeModelElement {
    public static final int NUM_SNAP_TO_LOCATIONS = (int)Math.floor(17.0);
    private final Point2D pivotPoint = new Point2D.Double();
    public final Property<Point2D> bottomCenterPoint = new Property<Point2D.Double>(new Point2D.Double());
    private double tiltAngle = 0.0;
    private double currentNetTorque = 0.0;
    private double angularVelocity = 0.0;
    private double maxTiltAngle;
    public final ObservableList<Mass> massesOnSurface = new ObservableList();
    private final Map<Mass, Double> mapMassToDistFromCenter = new HashMap<Mass, Double>();
    private final Property<ColumnState> columnState;
    private final Shape unrotatedShape;
    private final List<Shape> tickMarks = new ArrayList<Shape>();
    public final ObservableList<MassForceVector> forceVectorList = new ObservableList();
    public final BooleanProperty userControlled = new BooleanProperty(false);
    private boolean isStill = true;

    public Plank(ConstantDtClock constantDtClock, Point2D point2D, Point2D point2D2, Property<ColumnState> property) {
        super(Plank.generateOriginalShape(point2D));
        this.columnState = property;
        this.pivotPoint.setLocation(point2D2);
        constantDtClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                Plank.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        this.unrotatedShape = Plank.generateOriginalShape(point2D);
        this.addShapeObserver(new VoidFunction1<Shape>(){

            @Override
            public void apply(Shape shape) {
                Plank.this.updateTickMarks();
            }
        });
        this.maxTiltAngle = Math.asin(point2D.getY() / 2.25);
        this.bottomCenterPoint.set(new Point2D.Double(point2D.getX(), point2D.getY()));
        property.addObserver(new VoidFunction1<ColumnState>(){

            @Override
            public void apply(ColumnState columnState) {
                if (columnState == ColumnState.SINGLE_COLUMN) {
                    Plank.this.forceToMaxAndStill();
                } else if (columnState == ColumnState.DOUBLE_COLUMNS) {
                    Plank.this.forceToLevelAndStill();
                }
            }
        });
    }

    public static double getLength() {
        return 4.5;
    }

    public boolean addMassToSurface(final Mass mass) {
        boolean bl = false;
        Point2D point2D = this.getOpenMassDroppedLocation(mass.getPosition());
        if (this.isPointAbovePlank(mass.getMiddlePoint()) && point2D != null) {
            mass.setPosition(point2D);
            mass.setOnPlank(true);
            double d = this.getPlankSurfaceCenter().toPoint2D().distance(mass.getPosition()) * (double)(mass.getPosition().getX() > this.getPlankSurfaceCenter().getX() ? 1 : -1);
            this.mapMassToDistFromCenter.put(mass, d);
            this.forceVectorList.add(new MassForceVector(mass));
            mass.userControlled.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    if (bl.booleanValue()) {
                        Plank.this.removeMassFromSurface(mass);
                        mass.userControlled.removeObserver(this);
                    }
                }
            });
            this.massesOnSurface.add(mass);
            this.updateMassPositions();
            this.updateNetTorque();
            bl = true;
            double d2 = d;
            SimSharingManager.sendModelMessage(BalanceAndTorqueSimSharing.ModelComponents.plank, ModelComponentTypes.modelElement, BalanceAndTorqueSimSharing.ModelActions.massAddedToPlank, new ParameterSet().with(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.massUserComponent, mass.getUserComponent().toString())).with(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.massValue, mass.getMass())).with(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.distanceFromPlankCenter, d2)).with(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.massValueShown, !mass.isMystery())));
        }
        return bl;
    }

    public void addMassToSurface(Mass mass, double d) {
        assert (d <= 2.25);
        if (d > 2.25) {
            System.out.println(this.getClass().getName() + " - Warning: Attempt to add mass at invalid distance from center, ignoring.");
            return;
        }
        Vector2D vector2D = this.getPlankSurfaceCenter().plus(new Vector2D(d, 0.0).getRotatedInstance(this.tiltAngle));
        mass.setPosition(vector2D.getX(), vector2D.getY() + 0.01);
        assert (this.isPointAbovePlank(mass.getPosition()));
        this.addMassToSurface(mass);
    }

    private void removeMassFromSurface(Mass mass) {
        this.mapMassToDistFromCenter.remove(mass);
        this.massesOnSurface.remove(mass);
        mass.setRotationAngle(0.0);
        mass.setOnPlank(false);
        for (MassForceVector massForceVector : new ArrayList<MassForceVector>(this.forceVectorList)) {
            if (mass != massForceVector.mass) continue;
            this.forceVectorList.remove(massForceVector);
        }
        this.updateNetTorque();
        SimSharingManager.sendModelMessage(BalanceAndTorqueSimSharing.ModelComponents.plank, ModelComponentTypes.modelElement, BalanceAndTorqueSimSharing.ModelActions.massRemovedFromPlank, new ParameterSet(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.massUserComponent, mass.getUserComponent().toString())));
    }

    public void removeAllMasses() {
        for (Mass mass : new ArrayList<Mass>(this.massesOnSurface)) {
            this.removeMassFromSurface(mass);
        }
    }

    public Point2D getPivotPoint() {
        return new Point2D.Double(this.pivotPoint.getX(), this.pivotPoint.getY());
    }

    public double getTiltAngle() {
        return this.tiltAngle;
    }

    public void setTiltAngle(double d) {
        double d2 = MathUtil.clamp(-this.maxTiltAngle, d, this.maxTiltAngle);
        if (this.columnState.get() == ColumnState.NONE && Math.abs(d2) <= this.maxTiltAngle) {
            this.tiltAngle = d2;
            this.updatePlankPosition();
            this.updateMassPositions();
        } else {
            System.out.println(this.getClass().getName() + " - Warning: Attempt to set tilt angle of plank while columns present, ignoring.");
        }
    }

    public List<Shape> getTickMarks() {
        return this.tickMarks;
    }

    public boolean isTickMarkOccupied(Shape shape) {
        Point2D.Double double_ = new Point2D.Double(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY());
        double d = this.getPlankSurfaceCenter().toPoint2D().distance(double_);
        if (((Point2D)double_).getX() < this.getPlankSurfaceCenter().getX()) {
            d = -d;
        }
        double d2 = 0.05;
        boolean bl = false;
        for (Mass mass : this.mapMassToDistFromCenter.keySet()) {
            double d3 = this.mapMassToDistFromCenter.get(mass);
            if (!(d3 > d - d2) || !(d3 < d + d2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static Shape generateOriginalShape(Point2D point2D) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(0.0, 0.0);
        doubleGeneralPath.lineTo(2.25, 0.0);
        doubleGeneralPath.lineTo(2.25, 0.05);
        doubleGeneralPath.lineTo(0.0, 0.05);
        doubleGeneralPath.lineTo(-2.25, 0.05);
        doubleGeneralPath.lineTo(-2.25, 0.0);
        doubleGeneralPath.lineTo(0.0, 0.0);
        return AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape(doubleGeneralPath.getGeneralPath());
    }

    private void updateTickMarks() {
        this.tickMarks.clear();
        double d = 4.5 / (double)(NUM_SNAP_TO_LOCATIONS + 1);
        double d2 = this.unrotatedShape.getBounds2D().getMinX() + d;
        double d3 = this.unrotatedShape.getBounds2D().getMinY();
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.tiltAngle, this.pivotPoint.getX(), this.pivotPoint.getY());
        for (int i = 0; i < NUM_SNAP_TO_LOCATIONS; ++i) {
            double d4 = d2 + d * (double)i;
            doubleGeneralPath.moveTo(d4, d3);
            doubleGeneralPath.lineTo(d4, d3 + 0.05);
            this.tickMarks.add(affineTransform.createTransformedShape(doubleGeneralPath.getGeneralPath()));
            doubleGeneralPath.reset();
        }
    }

    private void updatePlankPosition() {
        this.setShape(AffineTransform.getRotateInstance(this.tiltAngle, this.pivotPoint.getX(), this.pivotPoint.getY()).createTransformedShape(this.unrotatedShape));
        assert (this.pivotPoint.getY() >= this.unrotatedShape.getBounds2D().getMinY());
        MutableVector2D mutableVector2D = new MutableVector2D(this.pivotPoint);
        MutableVector2D mutableVector2D2 = new MutableVector2D(0.0, this.unrotatedShape.getBounds2D().getY() - this.pivotPoint.getY());
        mutableVector2D2.rotate(this.tiltAngle);
        this.bottomCenterPoint.set(mutableVector2D.add(mutableVector2D2).toPoint2D());
    }

    private Point2D getOpenMassDroppedLocation(Point2D point2D) {
        Point2D point2D2 = null;
        List<Point2D> list = this.getSnapToLocations();
        if (NUM_SNAP_TO_LOCATIONS % 2 == 1) {
            list.remove(NUM_SNAP_TO_LOCATIONS / 2);
        }
        for (Point2D point2D3 : new ArrayList<Point2D>(list)) {
            for (Mass mass : this.massesOnSurface) {
                if (!(mass.getPosition().distance(point2D3) < 0.025)) continue;
                list.remove(point2D3);
            }
        }
        for (Point2D point2D3 : list) {
            if (!(Math.abs(point2D3.getX() - point2D.getX()) <= 0.25) || point2D2 != null && !(point2D3.distance(point2D) < point2D2.distance(point2D))) continue;
            point2D2 = point2D3;
        }
        return point2D2;
    }

    private void forceToLevelAndStill() {
        this.forceAngle(0.0);
    }

    private void forceToMaxAndStill() {
        this.forceAngle(this.getMaxTiltAngle());
    }

    private void forceAngle(double d) {
        this.angularVelocity = 0.0;
        this.tiltAngle = d;
        this.updatePlankPosition();
        this.updateMassPositions();
    }

    private void stepInTime(double d) {
        if (!((Boolean)this.userControlled.get()).booleanValue()) {
            this.updateNetTorque();
            double d2 = this.currentNetTorque / 126.578125;
            d2 = Math.abs(d2) > 1.0E-5 ? d2 : 0.0;
            this.angularVelocity += d2;
            this.angularVelocity = Math.abs(this.angularVelocity) > 1.0E-5 ? this.angularVelocity : 0.0;
            double d3 = this.tiltAngle;
            this.tiltAngle += this.angularVelocity * d;
            if (Math.abs(this.tiltAngle) > this.maxTiltAngle) {
                this.tiltAngle = this.maxTiltAngle * (double)(this.tiltAngle < 0.0 ? -1 : 1);
                this.angularVelocity = 0.0;
            } else if (Math.abs(this.tiltAngle) < 1.0E-4) {
                this.tiltAngle = 0.0;
            }
            if (this.angularVelocity != 0.0 && this.isStill) {
                SimSharingManager.sendModelMessage(BalanceAndTorqueSimSharing.ModelComponents.plank, ModelComponentTypes.modelElement, BalanceAndTorqueSimSharing.ModelActions.startedTilting, new ParameterSet(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.plankTiltAngle, d3)));
                this.isStill = false;
            } else if (this.angularVelocity == 0.0 && !this.isStill) {
                SimSharingManager.sendModelMessage(BalanceAndTorqueSimSharing.ModelComponents.plank, ModelComponentTypes.modelElement, BalanceAndTorqueSimSharing.ModelActions.stoppedTilting, new ParameterSet(new Parameter((IParameterKey)BalanceAndTorqueSimSharing.ParameterKeys.plankTiltAngle, d3)));
                this.isStill = true;
            }
            if (this.tiltAngle != d3) {
                this.updatePlankPosition();
                this.updateMassPositions();
            }
            this.angularVelocity *= 0.91;
        }
    }

    private void updateMassPositions() {
        for (Mass object : this.massesOnSurface) {
            Vector2D vector2D = new MutableVector2D(this.mapMassToDistFromCenter.get(object), 0.0).getRotatedInstance(this.tiltAngle);
            Vector2D vector2D2 = this.getPlankSurfaceCenter().plus(vector2D);
            object.setPosition(vector2D2.toPoint2D());
            object.setRotationAngle(this.tiltAngle);
        }
        for (MassForceVector massForceVector : this.forceVectorList) {
            massForceVector.update();
        }
    }

    public Vector2D getPlankSurfaceCenter() {
        return new Vector2D(this.bottomCenterPoint.get()).plus(new Vector2D(0.0, 0.05).getRotatedInstance(this.tiltAngle));
    }

    public double getSurfaceYValue(double d) {
        double d2 = Math.tan(this.tiltAngle);
        double d3 = this.getPlankSurfaceCenter().getY() - d2 * this.getPlankSurfaceCenter().getX();
        return d2 * d + d3;
    }

    public boolean isPointAbovePlank(Point2D point2D) {
        Rectangle2D rectangle2D = this.getShape().getBounds2D();
        return point2D.getX() >= rectangle2D.getMinX() && point2D.getX() <= rectangle2D.getMaxX() && point2D.getY() > this.getSurfaceYValue(point2D.getX());
    }

    public boolean isBalanced() {
        double d = 0.0;
        for (Mass mass : this.massesOnSurface) {
            assert (this.mapMassToDistFromCenter.containsKey(mass));
            d += mass.getMass() * this.mapMassToDistFromCenter.get(mass);
        }
        return Math.abs(d) < 1.0E-6;
    }

    private void updateNetTorque() {
        this.currentNetTorque = 0.0;
        if (this.columnState.get() == ColumnState.NONE) {
            this.currentNetTorque += this.getTorqueDueToMasses();
            this.currentNetTorque += (this.pivotPoint.getX() - this.bottomCenterPoint.get().getX()) * 75.0;
        }
    }

    public double getTorqueDueToMasses() {
        double d = 0.0;
        for (Mass mass : this.massesOnSurface) {
            d += this.pivotPoint.getX() - mass.getPosition().getX() * mass.getMass();
        }
        return d;
    }

    private List<Point2D> getSnapToLocations() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(NUM_SNAP_TO_LOCATIONS);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.tiltAngle, this.pivotPoint.getX(), this.pivotPoint.getY());
        double d = this.unrotatedShape.getBounds2D().getMaxY();
        double d2 = this.unrotatedShape.getBounds2D().getMinX();
        for (int i = 0; i < NUM_SNAP_TO_LOCATIONS; ++i) {
            Point2D.Double double_ = new Point2D.Double(d2 + (double)(i + 1) * 0.25, d);
            arrayList.add(affineTransform.transform(double_, null));
        }
        return arrayList;
    }

    public List<MassDistancePair> getMassDistancePairs() {
        ArrayList<MassDistancePair> arrayList = new ArrayList<MassDistancePair>();
        for (Mass mass : this.mapMassToDistFromCenter.keySet()) {
            arrayList.add(new MassDistancePair(mass, this.mapMassToDistFromCenter.get(mass)));
        }
        return arrayList;
    }

    public ParameterSet getMassStateParameterSet() {
        ParameterSet parameterSet = new ParameterSet();
        for (int i = 0; i < this.massesOnSurface.size(); ++i) {
            Mass mass = this.massesOnSurface.get(i);
            double d = this.mapMassToDistFromCenter.get(mass);
            parameterSet = parameterSet.with(new Parameter((IParameterKey)new ParameterKeyWithID(BalanceAndTorqueSimSharing.ParameterKeys.massUserComponent, i), mass.getUserComponent().toString()));
            parameterSet = parameterSet.with(new Parameter((IParameterKey)new ParameterKeyWithID(BalanceAndTorqueSimSharing.ParameterKeys.massValue, i), mass.getMass()));
            parameterSet = parameterSet.with(new Parameter((IParameterKey)new ParameterKeyWithID(BalanceAndTorqueSimSharing.ParameterKeys.distanceFromPlankCenter, i), d));
            parameterSet = parameterSet.with(new Parameter((IParameterKey)new ParameterKeyWithID(BalanceAndTorqueSimSharing.ParameterKeys.massValueShown, i), !mass.isMystery()));
        }
        return parameterSet;
    }

    public double getMaxTiltAngle() {
        return this.maxTiltAngle;
    }

    public static class MassForceVector {
        public final Mass mass;
        public final Property<PositionedVector> forceVectorProperty;

        public MassForceVector(Mass mass) {
            this.mass = mass;
            this.forceVectorProperty = new Property<PositionedVector>(this.generateVector(mass));
        }

        public void update() {
            this.forceVectorProperty.set(this.generateVector(this.mass));
        }

        public boolean isObfuscated() {
            return this.mass.isMystery();
        }

        private PositionedVector generateVector(Mass mass) {
            return new PositionedVector(new Vector2D(mass.getPosition()), new Vector2D(0.0, mass.getMass() * -9.8));
        }
    }

    static class ParameterKeyWithID
    implements IParameterKey {
        private final String value;

        public ParameterKeyWithID(IParameterKey iParameterKey, int n) {
            this.value = iParameterKey + ":" + n;
        }

        public String toString() {
            return this.value;
        }
    }
}

