/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model;

import edu.colorado.phet.balanceandtorque.common.model.AttachmentBar;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.FulcrumAbovePlank;
import edu.colorado.phet.balanceandtorque.common.model.LevelSupportColumn;
import edu.colorado.phet.balanceandtorque.common.model.Plank;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BalanceModel
implements Resettable {
    protected final ConstantDtClock clock = new ConstantDtClock(30.0);
    public final ObservableList<Mass> massList = new ObservableList();
    private final FulcrumAbovePlank fulcrum = new FulcrumAbovePlank(1.0, 0.85);
    private final List<LevelSupportColumn> supportColumns = new ArrayList<LevelSupportColumn>(){
        {
            this.add(new LevelSupportColumn(0.75, -1.625));
            this.add(new LevelSupportColumn(0.75, 1.625));
        }
    };
    public final Property<ColumnState> columnState = new Property<ColumnState>(ColumnState.DOUBLE_COLUMNS);
    protected final Plank plank = new Plank(this.clock, new Point2D.Double(0.0, 0.75), new Point2D.Double(0.0, 0.85), this.columnState);
    private final AttachmentBar attachmentBar = new AttachmentBar(this.plank);

    public BalanceModel() {
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                BalanceModel.this.stepInTime(BalanceModel.this.clock.getDt());
            }
        });
    }

    public ConstantDtClock getClock() {
        return this.clock;
    }

    protected void stepInTime(double d) {
        for (Mass mass : new ArrayList<Mass>(this.massList)) {
            mass.stepInTime(d);
        }
    }

    public void addMass(Mass mass) {
        this.massList.add(mass);
    }

    protected void removeMass(Mass mass) {
        this.massList.remove(mass);
    }

    @Override
    public void reset() {
        this.getClock().resetSimulationTime();
        this.plank.removeAllMasses();
        this.columnState.reset();
    }

    public FulcrumAbovePlank getFulcrum() {
        return this.fulcrum;
    }

    public Plank getPlank() {
        return this.plank;
    }

    public AttachmentBar getAttachmentBar() {
        return this.attachmentBar;
    }

    public List<LevelSupportColumn> getSupportColumns() {
        return this.supportColumns;
    }
}

