/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.balancelab.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.BalanceModel;
import edu.colorado.phet.balanceandtorque.common.model.UserMovableModelElement;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Font;
import java.awt.geom.Point2D;

public abstract class ModelElementCreatorNode
extends PComposite {
    private static final Font LABEL_FONT = new PhetFont(16);
    UserMovableModelElement modelElement = null;
    protected final BalanceModel model;
    private final PhetPCanvas canvas;
    private final ModelViewTransform mvt;
    private PNode selectionNode = null;
    private PText caption = null;
    private final MutableVector2D positioningOffset = new MutableVector2D(0.0, 0.0);

    public ModelElementCreatorNode(BalanceModel balanceModel, ModelViewTransform modelViewTransform, PhetPCanvas phetPCanvas) {
        this.model = balanceModel;
        this.mvt = modelViewTransform;
        this.canvas = phetPCanvas;
        this.addInputEventListener(new CursorHandler(12));
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                ModelElementCreatorNode.this.modelElement = ModelElementCreatorNode.this.addElementToModel(ModelElementCreatorNode.this.getModelPosition(pInputEvent.getCanvasPosition()));
                SimSharingManager.sendUserMessage(ModelElementCreatorNode.this.modelElement.getUserComponent(), ModelElementCreatorNode.this.modelElement.getUserComponentType(), BalanceAndTorqueSimSharing.UserActions.createdMass);
                ParameterSet parameterSet = new ParameterSet().with(new Parameter((IParameterKey)ParameterKeys.canvasPositionX, pInputEvent.getCanvasPosition().getX())).with(new Parameter((IParameterKey)ParameterKeys.canvasPositionY, pInputEvent.getCanvasPosition().getY()));
                SimSharingManager.sendUserMessage(ModelElementCreatorNode.this.modelElement.getUserComponent(), ModelElementCreatorNode.this.modelElement.getUserComponentType(), UserActions.startDrag, parameterSet);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                ModelElementCreatorNode.this.modelElement.setPosition(ModelElementCreatorNode.this.getModelPosition(pInputEvent.getCanvasPosition()));
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                ParameterSet parameterSet = new ParameterSet().with(new Parameter((IParameterKey)ParameterKeys.canvasPositionX, pInputEvent.getCanvasPosition().getX())).with(new Parameter((IParameterKey)ParameterKeys.canvasPositionY, pInputEvent.getCanvasPosition().getY()));
                SimSharingManager.sendUserMessage(ModelElementCreatorNode.this.modelElement.getUserComponent(), ModelElementCreatorNode.this.modelElement.getUserComponentType(), UserActions.endDrag, parameterSet);
                ModelElementCreatorNode.this.modelElement.release();
                ModelElementCreatorNode.this.modelElement = null;
            }
        });
    }

    protected abstract UserMovableModelElement addElementToModel(Point2D var1);

    protected void setSelectionNode(PNode pNode) {
        assert (this.selectionNode == null);
        this.selectionNode = pNode;
        this.addChild(pNode);
        this.updateLayout();
    }

    protected void setCaption(String string) {
        this.caption = new PText(string);
        this.caption.setFont(LABEL_FONT);
        this.addChild(this.caption);
        this.updateLayout();
    }

    protected void setPositioningOffset(double d, double d2) {
        this.positioningOffset.setComponents(d, d2);
    }

    private Point2D getModelPosition(Point2D point2D) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        this.canvas.getPhetRootNode().screenToWorld(double_);
        double_ = new MutableVector2D(double_).add(this.positioningOffset).toPoint2D();
        return this.mvt.viewToModel(double_);
    }

    private void updateLayout() {
        if (this.caption != null && this.selectionNode != null) {
            this.caption.setOffset(-this.caption.getFullBoundsReference().getWidth() / 2.0, this.selectionNode.getFullBoundsReference().getMaxY() + 4.0);
        }
    }
}

