/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.balancelab.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.common.model.masses.ImageMass;
import edu.colorado.phet.balanceandtorque.common.view.MassDragHandler;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;

public class ImageMassNode
extends PNode {
    private static final Format MASS_VALUE_FORMAT = new DecimalFormat("##.#");
    private final ImageMass mass;
    private final ModelViewTransform mvt;
    protected final PImage imageNode = new PImage();
    private PText massLabel;

    public ImageMassNode(final ModelViewTransform modelViewTransform, final ImageMass imageMass, PhetPCanvas phetPCanvas, BooleanProperty booleanProperty) {
        this.mass = imageMass;
        this.mvt = modelViewTransform;
        this.massLabel = new PText(){
            {
                this.setFont(new PhetFont(14));
                if (imageMass.isMystery()) {
                    this.setText(BalanceAndTorqueResources.Strings.UNKNOWN_MASS_LABEL);
                } else {
                    String string = MASS_VALUE_FORMAT.format(imageMass.getMass());
                    this.setText(MessageFormat.format(BalanceAndTorqueResources.Strings.PATTERN_0_VALUE_1_UNITS, string, BalanceAndTorqueResources.Strings.KG));
                }
            }
        };
        this.addChild(this.massLabel);
        booleanProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                ImageMassNode.this.massLabel.setVisible(bl);
            }
        });
        this.addChild(this.imageNode);
        imageMass.addImageChangeObserver(new VoidFunction1<BufferedImage>(){

            @Override
            public void apply(BufferedImage bufferedImage) {
                ImageMassNode.this.imageNode.setScale(1.0);
                ImageMassNode.this.imageNode.setImage(bufferedImage);
                double d = Math.abs(modelViewTransform.modelToViewDeltaY(imageMass.getHeight())) / ImageMassNode.this.imageNode.getFullBoundsReference().height;
                if (d > 2.0 || d < 0.5) {
                    System.out.println(this.getClass().getName() + " - Warning: Scaling factor is too large or small, drawing size should be adjusted.  Scaling factor = " + d);
                    System.out.println("        Scaled class: " + imageMass.getClass().getName());
                }
                if (d > 1.0) {
                    System.out.println("Scaling up, factor = " + d);
                    System.out.println("        Scaled class: " + imageMass.getClass().getName());
                }
                ImageMassNode.this.imageNode.setScale(d);
                ImageMassNode.this.updatePositionAndAngle();
            }
        });
        imageMass.addHeightChangeObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                ImageMassNode.this.imageNode.setScale(1.0);
                double d2 = Math.abs(modelViewTransform.modelToViewDeltaY(d)) / ImageMassNode.this.imageNode.getFullBoundsReference().height;
                ImageMassNode.this.imageNode.setScale(d2);
                ImageMassNode.this.updatePositionAndAngle();
            }
        });
        imageMass.addPositionChangeObserver(new VoidFunction1<Point2D>(){

            @Override
            public void apply(Point2D point2D) {
                ImageMassNode.this.updatePositionAndAngle();
            }
        });
        imageMass.addRotationalAngleChangeObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                ImageMassNode.this.updatePositionAndAngle();
            }
        });
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new MassDragHandler(imageMass, this, phetPCanvas, modelViewTransform));
    }

    private void updatePositionAndAngle() {
        this.setRotation(0.0);
        this.massLabel.setOffset(this.imageNode.getFullBoundsReference().getCenterX() + this.mvt.modelToViewDeltaX(this.mass.getCenterOfMassXOffset()) - this.massLabel.getFullBoundsReference().width / 2.0, -(this.massLabel.getFullBoundsReference().height * 1.2));
        this.setOffset(this.mvt.modelToViewX(this.mass.getPosition().getX() - this.mass.getCenterOfMassXOffset()) - this.imageNode.getFullBoundsReference().width / 2.0, this.mvt.modelToViewY(this.mass.getPosition().getY()) - this.imageNode.getFullBoundsReference().height);
        this.rotateAboutPoint(-this.mass.getRotationAngle(), this.getFullBoundsReference().getWidth() / 2.0 + this.mvt.modelToViewDeltaX(this.mass.getCenterOfMassXOffset()), this.imageNode.getFullBoundsReference().getHeight());
    }
}

