/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.balancelab.view;

import edu.colorado.phet.balanceandtorque.balancelab.view.MassCreatorNode;
import edu.colorado.phet.balanceandtorque.common.model.BalanceModel;
import edu.colorado.phet.balanceandtorque.common.model.UserMovableModelElement;
import edu.colorado.phet.balanceandtorque.common.model.masses.BrickStack;
import edu.colorado.phet.balanceandtorque.common.view.BrickStackNode;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import java.awt.geom.Point2D;

public class BrickStackCreatorNode
extends MassCreatorNode {
    protected static final ModelViewTransform SCALING_MVT = ModelViewTransform.createOffsetScaleMapping(new Point2D.Double(0.0, 0.0), 150.0);
    private final int numBricks;

    public BrickStackCreatorNode(int n, BalanceModel balanceModel, ModelViewTransform modelViewTransform, PhetPCanvas phetPCanvas) {
        super(balanceModel, modelViewTransform, phetPCanvas, (double)n * 5.0, true);
        this.numBricks = n;
        this.setSelectionNode(new BrickStackNode(new BrickStack(n, new Point2D.Double(0.0, 0.0)), SCALING_MVT, phetPCanvas, new BooleanProperty(false)));
        this.setPositioningOffset(0.0, -modelViewTransform.modelToViewDeltaY(0.06666666666666667 * (double)n / 2.0));
    }

    protected UserMovableModelElement addElementToModel(Point2D point2D) {
        BrickStack brickStack = new BrickStack(this.numBricks, point2D);
        brickStack.userControlled.set(true);
        brickStack.setAnimationDestination(point2D.getX(), point2D.getY());
        this.model.addMass(brickStack);
        return brickStack;
    }
}

