/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChemicalSymbolNode
extends PComposite {
    private final double capHeight;

    public ChemicalSymbolNode(String string, Font font, Color color) {
        this(string, font, color, 0.8, 0.8);
    }

    public ChemicalSymbolNode(String string, Font font, Color color, double d, double d2) {
        NormalNode normalNode = new NormalNode("A", font, color);
        this.capHeight = normalNode.getFullBoundsReference().getHeight();
        ArrayList<FragmentNode> arrayList = ChemicalSymbolNode.htmlToNodes(string, font, color, d, d2);
        Iterator<FragmentNode> iterator = arrayList.iterator();
        double d3 = 0.0;
        while (iterator.hasNext()) {
            FragmentNode fragmentNode = iterator.next();
            this.addChild(fragmentNode);
            if (fragmentNode instanceof NormalNode) {
                fragmentNode.setOffset(d3, -this.capHeight);
            } else if (fragmentNode instanceof SuperscriptNode) {
                fragmentNode.setOffset(d3, -this.capHeight - fragmentNode.getFullBoundsReference().getHeight() / 2.0);
            } else if (fragmentNode instanceof SubscriptNode) {
                fragmentNode.setOffset(d3, -this.capHeight + fragmentNode.getFullBoundsReference().getHeight() / 2.0);
            } else {
                throw new UnsupportedOperationException("unsupported node type: " + fragmentNode.getClass().getName());
            }
            d3 += fragmentNode.getFullBoundsReference().getWidth() + 0.0;
        }
    }

    public double getCapHeight() {
        return this.capHeight;
    }

    private static ArrayList<FragmentNode> htmlToNodes(String string, Font font, Color color, double d, double d2) {
        ArrayList<FragmentNode> arrayList = new ArrayList<FragmentNode>();
        String string2 = new String(string);
        if (string2.startsWith("<html>")) {
            string2 = string2.substring("<html>".length());
        }
        if (string2.endsWith("</html>")) {
            string2 = string2.substring(0, string2.length() - "</html>".length());
        }
        boolean bl = false;
        String string3 = null;
        while (!bl) {
            int n = string2.indexOf("<sub>");
            int n2 = string2.indexOf("<sup>");
            int n3 = n == -1 ? n2 : (n2 == -1 ? n : Math.min(n2, n));
            if (n3 == -1) {
                if (string2.length() > 0) {
                    arrayList.add(new NormalNode(string2, font, color));
                }
                bl = true;
                continue;
            }
            string3 = string2.substring(0, n3);
            if (string3.length() > 0) {
                arrayList.add(new NormalNode(string3, font, color));
            }
            if ((string2 = string2.substring(n3, string2.length())).startsWith("<sup>")) {
                n3 = string2.indexOf("</sup>");
                if (n3 == -1) {
                    throw new UnsupportedOperationException("malformed HTML, missing </sup>: " + string2);
                }
                string3 = string2.substring("<sup>".length(), n3);
                arrayList.add(new SuperscriptNode(string3, font, color, d));
                string2 = string2.substring(n3 + "</sup>".length(), string2.length());
                continue;
            }
            if (string2.startsWith("<sub>")) {
                n3 = string2.indexOf("</sub>");
                if (n3 == -1) {
                    throw new UnsupportedOperationException("malformed HTML, missing </sub>: " + string2);
                }
                string3 = string2.substring("<sub>".length(), n3);
                arrayList.add(new SubscriptNode(string3, font, color, d2));
                string2 = string2.substring(n3 + "</sub>".length(), string2.length());
                continue;
            }
            string2 = string2.substring(n3 + 1, string2.length());
        }
        return arrayList;
    }

    private static abstract class FragmentNode
    extends HTMLNode {
        public FragmentNode(String string, Font font, Color color) {
            super(HTMLUtils.toHTMLString(string));
            this.setFont(font);
            this.setHTMLColor(color);
        }
    }

    private static class NormalNode
    extends FragmentNode {
        public NormalNode(String string, Font font, Color color) {
            super(string, font, color);
            if (!string.matches(".*[A-Z]+.*")) {
                throw new IllegalArgumentException("text must contain at least one uppercase char: " + string);
            }
        }
    }

    private static class SubscriptNode
    extends FragmentNode {
        public SubscriptNode(String string, Font font, Color color, double d) {
            super(string, font, color);
            this.scale(d);
        }
    }

    private static class SuperscriptNode
    extends FragmentNode {
        public SuperscriptNode(String string, Font font, Color color, double d) {
            super(string, font, color);
            this.scale(d);
        }
    }
}

