/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Color;

public class ColorUtils {
    private ColorUtils() {
    }

    public static Color interpolateRBGA(Color color, Color color2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("distance out of range: " + d);
        }
        int n = (int)ColorUtils.interpolate(color.getRed(), color2.getRed(), d);
        int n2 = (int)ColorUtils.interpolate(color.getGreen(), color2.getGreen(), d);
        int n3 = (int)ColorUtils.interpolate(color.getBlue(), color2.getBlue(), d);
        int n4 = (int)ColorUtils.interpolate(color.getAlpha(), color2.getAlpha(), d);
        return new Color(n, n2, n3, n4);
    }

    private static double interpolate(double d, double d2, double d3) {
        assert (d3 >= 0.0 && d3 <= 1.0);
        return d + d3 * (d2 - d);
    }
}

