/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics.transforms;

import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ModelViewTransform {
    private AffineTransform transform;

    private ModelViewTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public static ModelViewTransform createIdentity() {
        return new ModelViewTransform(new AffineTransform());
    }

    public Point2D modelToView(Point2D point2D) {
        return this.transform.transform(point2D, null);
    }

    public Shape modelToView(Shape shape) {
        return this.transform.createTransformedShape(shape);
    }

    public Dimension2D modelToViewSize(Dimension2D dimension2D) {
        Rectangle2D rectangle2D = this.modelToView(new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight())).getBounds2D();
        return new Dimension2DDouble(rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Point2D viewToModel(Point2D point2D) {
        return this.getInverseTransform().transform(point2D, null);
    }

    public Point2D viewToModel(double d, double d2) {
        return this.viewToModel(new Point2D.Double(d, d2));
    }

    protected AffineTransform getInverseTransform() {
        try {
            return this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.transform.equals(((ModelViewTransform)object).transform);
    }

    public int hashCode() {
        return this.transform.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.transform.toString();
    }
}

