/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view.graph;

import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.FormattedNumberNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;

class NegligibleValueNode
extends PhetPNode {
    private static final Font VALUE_FONT = new PhetFont(0, 18);
    private static final Color VALUE_COLOR = Color.BLACK;
    private static final Font NEGLIGIBLE_FONT = new PhetFont(0, 20);
    private static final Color NEGLIGIBLE_COLOR = Color.BLACK;
    private final FormattedNumberNode numberNode;
    private final PText negligibleNode;
    private boolean negligibleEnabled;
    private double negligibleThreshold;

    public NegligibleValueNode(double d, NumberFormat numberFormat) {
        this.numberNode = new FormattedNumberNode(numberFormat, d, VALUE_FONT, VALUE_COLOR);
        this.addChild(this.numberNode);
        this.negligibleNode = new PText(ABSStrings.NEGLIGIBLE);
        this.negligibleNode.setFont(NEGLIGIBLE_FONT);
        this.negligibleNode.setTextPaint(NEGLIGIBLE_COLOR);
        this.addChild(this.negligibleNode);
        this.negligibleEnabled = false;
        this.negligibleThreshold = 0.0;
        this.update();
    }

    public NegligibleValueNode() {
        this(0.0, new DefaultDecimalFormat("0.0"));
    }

    public void setFormat(NumberFormat numberFormat) {
        this.numberNode.setFormat(numberFormat);
    }

    public void setValue(double d) {
        this.numberNode.setValue(d);
        this.update();
    }

    public void setNegligibleEnabled(boolean bl, double d) {
        if (bl != this.negligibleEnabled || d != this.negligibleThreshold) {
            this.negligibleEnabled = bl;
            this.negligibleThreshold = d;
            this.update();
        }
    }

    private void update() {
        double d = this.numberNode.getValue();
        if (d <= this.negligibleThreshold && this.negligibleEnabled) {
            this.addChild(this.negligibleNode);
            this.removeChild(this.numberNode);
        } else {
            this.addChild(this.numberNode);
            this.removeChild(this.negligibleNode);
        }
    }
}

