/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view.graph;

import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Line2D;

class ConcentrationYAxisNode
extends PComposite {
    private static final Font AXIS_LABEL_FONT = new PhetFont(20);
    private static final Color AXIS_LABEL_COLOR = Color.BLACK;
    private static final Stroke TICK_STROKE = new BasicStroke(1.0f);
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Font TICK_LABEL_FONT = new PhetFont(14);
    private static final Color TICK_LABEL_COLOR = Color.BLACK;
    private static final Stroke GRIDLINE_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final Color GRIDLINE_COLOR = new Color(192, 192, 192);

    public ConcentrationYAxisNode(PDimension pDimension, int n, double d, int n2, int n3) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        double d2 = pDimension.getHeight() - d;
        double d3 = d2 / (double)(n - 1);
        double d4 = d;
        int n4 = n2;
        PComposite pComposite = new PComposite();
        this.addChild(pComposite);
        for (int i = 0; i < n; ++i) {
            PPath pPath;
            if (i % n3 == 0) {
                pPath = new PPath(new Line2D.Double(-3.0, d4, 3.0, d4));
                pPath.setStroke(TICK_STROKE);
                pPath.setStrokePaint(TICK_COLOR);
                this.addChild(pPath);
                String string = "<html>10<sup>" + String.valueOf(n4) + "</sup></html>";
                HTMLNode hTMLNode = new HTMLNode(string);
                hTMLNode.setFont(TICK_LABEL_FONT);
                hTMLNode.setHTMLColor(TICK_LABEL_COLOR);
                double d5 = pPath.getFullBoundsReference().getMinX() - hTMLNode.getFullBoundsReference().getWidth() - 5.0;
                double d6 = pPath.getFullBoundsReference().getCenterY() - hTMLNode.getFullBoundsReference().getHeight() / 2.0;
                hTMLNode.setOffset(d5, d6);
                pComposite.addChild(hTMLNode);
            }
            pPath = new PPath(new Line2D.Double(3.0, d4, pDimension.getWidth() - 3.0, d4));
            pPath.setStroke(GRIDLINE_STROKE);
            pPath.setStrokePaint(GRIDLINE_COLOR);
            pComposite.addChild(pPath);
            d4 += d3;
            --n4;
        }
        PText pText = new PText(ABSStrings.CONCENTRATION_GRAPH_Y_AXIS);
        pText.rotate(-1.5707963267948966);
        pText.setFont(AXIS_LABEL_FONT);
        pText.setTextPaint(AXIS_LABEL_COLOR);
        pText.setPickable(false);
        this.addChild(pText);
        double d7 = pComposite.getFullBoundsReference().getX() - pText.getFullBoundsReference().getWidth() - 20.0;
        double d8 = pComposite.getFullBoundsReference().getCenterY() + pText.getFullBoundsReference().getHeight() / 2.0;
        pText.setOffset(d7, d8);
    }
}

