/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view.graph;

import edu.colorado.phet.acidbasesolutions.constants.ABSColors;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.model.AcidSolution;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.ConcentrationGraph;
import edu.colorado.phet.acidbasesolutions.model.PureWaterSolution;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.acidbasesolutions.model.StrongAcidSolution;
import edu.colorado.phet.acidbasesolutions.model.StrongBaseSolution;
import edu.colorado.phet.acidbasesolutions.model.WeakBaseSolution;
import edu.colorado.phet.acidbasesolutions.view.graph.AbstractConcentrationGraphNode;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.TimesTenNumberFormat;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ConcentrationGraphNode
extends AbstractConcentrationGraphNode {
    private static final TimesTenNumberFormat FORMAT = new TimesTenNumberFormat("0.00");
    private static final DecimalFormat H2O_FORMAT = new DefaultDecimalFormat("#0.0");
    private final ConcentrationGraph graph;

    public ConcentrationGraphNode(final ConcentrationGraph concentrationGraph) {
        super(concentrationGraph.getSizeReference(), false, false);
        this.graph = concentrationGraph;
        concentrationGraph.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void solutionChanged() {
                ConcentrationGraphNode.this.updateMolecules();
                ConcentrationGraphNode.this.updateValues();
            }

            public void concentrationChanged() {
                ConcentrationGraphNode.this.updateValues();
            }

            public void strengthChanged() {
                ConcentrationGraphNode.this.updateValues();
            }
        });
        concentrationGraph.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                ConcentrationGraphNode.this.setVisible(concentrationGraph.isVisible());
            }
        });
        double d = concentrationGraph.getLocationReference().getX() - concentrationGraph.getSizeReference().getWidth() / 2.0;
        double d2 = concentrationGraph.getLocationReference().getY() - this.getFullBoundsReference().getHeight() / 2.0;
        this.setOffset(d, d2);
        this.setVisible(concentrationGraph.isVisible());
        this.updateMolecules();
        this.updateValues();
        this.addInputEventListener(new NonInteractiveEventHandler(ABSSimSharing.UserComponents.concentrationGraph));
    }

    private void updateMolecules() {
        AqueousSolution aqueousSolution = this.graph.getSolution();
        if (aqueousSolution instanceof PureWaterSolution) {
            this.updateWaterMolecules(aqueousSolution);
        } else if (aqueousSolution instanceof AcidSolution) {
            this.updateAcidMolecules(aqueousSolution, aqueousSolution instanceof StrongAcidSolution);
        } else if (aqueousSolution instanceof StrongBaseSolution) {
            this.updateStrongBaseMolecules(aqueousSolution);
        } else if (aqueousSolution instanceof WeakBaseSolution) {
            this.updateWeakBaseMolecules(aqueousSolution);
        } else {
            throw new IllegalStateException("unsupported solution type: " + aqueousSolution.getClass().getName());
        }
        this.updateLayout();
    }

    private void updateWaterMolecules(AqueousSolution aqueousSolution) {
        this.setAllVisible(true);
        this.setMolecule(0, aqueousSolution.getWaterMolecule(), H2O_FORMAT);
        this.setMolecule(1, aqueousSolution.getH3OMolecule(), FORMAT);
        this.setMolecule(2, aqueousSolution.getOHMolecule(), FORMAT);
        this.setVisible(3, false);
    }

    private void updateAcidMolecules(AqueousSolution aqueousSolution, boolean bl) {
        this.setAllVisible(true);
        this.setMolecule(0, aqueousSolution.getSolute(), FORMAT, bl);
        this.setMolecule(1, aqueousSolution.getWaterMolecule(), H2O_FORMAT);
        this.setMolecule(2, aqueousSolution.getProduct(), FORMAT);
        this.setMolecule(3, aqueousSolution.getH3OMolecule(), FORMAT);
    }

    private void updateStrongBaseMolecules(AqueousSolution aqueousSolution) {
        this.setAllVisible(true);
        this.setMolecule(0, aqueousSolution.getSolute(), FORMAT, true);
        this.setMolecule(1, aqueousSolution.getProduct(), FORMAT);
        this.setMolecule(2, aqueousSolution.getOHMolecule(), FORMAT);
        this.setVisible(3, false);
    }

    private void updateWeakBaseMolecules(AqueousSolution aqueousSolution) {
        this.setAllVisible(true);
        this.setMolecule(0, aqueousSolution.getSolute(), FORMAT);
        this.setMolecule(1, aqueousSolution.getWaterMolecule(), H2O_FORMAT);
        this.setMolecule(2, aqueousSolution.getProduct(), FORMAT);
        this.setMolecule(3, aqueousSolution.getOHMolecule(), FORMAT);
    }

    private void updateValues() {
        AqueousSolution aqueousSolution = this.graph.getSolution();
        if (aqueousSolution instanceof PureWaterSolution) {
            this.updateWaterValues(aqueousSolution);
        } else if (aqueousSolution instanceof AcidSolution) {
            this.updateAcidValues(aqueousSolution);
        } else if (aqueousSolution instanceof StrongBaseSolution) {
            this.updateStrongBaseValues(aqueousSolution);
        } else if (aqueousSolution instanceof WeakBaseSolution) {
            this.updateWeakBaseValues(aqueousSolution);
        } else {
            throw new IllegalStateException("unsupported solution type: " + aqueousSolution.getClass().getName());
        }
    }

    private void updateWaterValues(AqueousSolution aqueousSolution) {
        this.setConcentration(0, aqueousSolution.getH2OConcentration());
        this.setConcentration(1, aqueousSolution.getH3OConcentration());
        this.setConcentration(2, aqueousSolution.getOHConcentration());
    }

    private void updateAcidValues(AqueousSolution aqueousSolution) {
        this.setConcentration(0, aqueousSolution.getSoluteConcentration());
        this.setConcentration(1, aqueousSolution.getH2OConcentration());
        this.setConcentration(2, aqueousSolution.getProductConcentration());
        this.setConcentration(3, aqueousSolution.getH3OConcentration());
    }

    private void updateStrongBaseValues(AqueousSolution aqueousSolution) {
        this.setConcentration(0, aqueousSolution.getSoluteConcentration());
        this.setConcentration(1, aqueousSolution.getProductConcentration());
        this.setConcentration(2, aqueousSolution.getOHConcentration());
    }

    private void updateWeakBaseValues(AqueousSolution aqueousSolution) {
        this.setConcentration(0, aqueousSolution.getSoluteConcentration());
        this.setConcentration(1, aqueousSolution.getH2OConcentration());
        this.setConcentration(2, aqueousSolution.getProductConcentration());
        this.setConcentration(3, aqueousSolution.getOHConcentration());
    }

    public static Icon createIcon() {
        PComposite pComposite = new PComposite();
        PDimension pDimension = new PDimension(30.0, 22.0);
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight()));
        pPath.setPaint(OUTLINE_FILL_COLOR);
        pPath.setStroke(null);
        pComposite.addChild(pPath);
        Color[] colorArray = new Color[]{ABSColors.HA, ABSColors.H2O, ABSColors.A_MINUS, ABSColors.H3O_PLUS};
        double[] dArray = new double[]{0.65, 0.8, 0.5, 0.5};
        assert (dArray.length == colorArray.length);
        double d = 0.1 * pDimension.getWidth();
        double d2 = (pDimension.getWidth() - d * (double)(colorArray.length + 1)) / (double)colorArray.length;
        double d3 = d;
        for (int i = 0; i < colorArray.length; ++i) {
            double d4 = dArray[i] * pDimension.getHeight();
            double d5 = pDimension.getHeight() - d4;
            PPath pPath2 = new PPath(new Rectangle2D.Double(d3, d5, d2, d4));
            pPath2.setPaint(colorArray[i]);
            pPath2.setStroke(null);
            pComposite.addChild(pPath2);
            d3 = d3 + d2 + d;
        }
        PPath pPath3 = new PPath(new Rectangle2D.Double(0.25, 0.25, pDimension.getWidth() - 0.5, pDimension.getHeight() - 0.5));
        pPath3.setStrokePaint(OUTLINE_STROKE_COLOR);
        pComposite.addChild(pPath3);
        return new ImageIcon(pComposite.toImage());
    }
}

