/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view.graph;

import edu.colorado.phet.acidbasesolutions.model.Molecule;
import edu.colorado.phet.acidbasesolutions.view.graph.ConcentrationYAxisNode;
import edu.colorado.phet.acidbasesolutions.view.graph.NegligibleValueNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

abstract class AbstractConcentrationGraphNode
extends PComposite {
    private static final Stroke OUTLINE_STROKE = new BasicStroke(1.0f);
    protected static final Color OUTLINE_STROKE_COLOR = Color.BLACK;
    protected static final Color OUTLINE_FILL_COLOR = Color.WHITE;
    private static final Font SYMBOL_FONT = new PhetFont(16);
    private final PDimension outlineSize;
    private final PPath graphOutlineNode;
    private final ConcentrationNode[] concentrationNodes;
    private final ConcentrationYAxisNode yAxisNode;

    public AbstractConcentrationGraphNode(PDimension pDimension, boolean bl, boolean bl2) {
        this.outlineSize = new PDimension(pDimension);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight());
        this.graphOutlineNode = new PPath(double_);
        this.graphOutlineNode.setStroke(OUTLINE_STROKE);
        this.graphOutlineNode.setStrokePaint(OUTLINE_STROKE_COLOR);
        this.graphOutlineNode.setPaint(OUTLINE_FILL_COLOR);
        this.addChild(this.graphOutlineNode);
        this.yAxisNode = new ConcentrationYAxisNode(pDimension, 11, 10.0, 2, 1);
        this.addChild(this.yAxisNode);
        double d = pDimension.getHeight() - 10.0;
        this.concentrationNodes = new ConcentrationNode[4];
        for (int i = 0; i < this.concentrationNodes.length; ++i) {
            this.concentrationNodes[i] = new ConcentrationNode(d, bl, bl2);
            this.addChild(this.concentrationNodes[i]);
        }
        PPath pPath = new PPath(new Line2D.Double(0.0, pDimension.getHeight(), pDimension.getWidth(), pDimension.getHeight()));
        pPath.setStroke(OUTLINE_STROKE);
        pPath.setStrokePaint(OUTLINE_STROKE_COLOR);
        this.addChild(pPath);
        this.graphOutlineNode.setOffset(0.0, 0.0);
        this.yAxisNode.setOffset(this.graphOutlineNode.getOffset());
        this.updateLayout();
    }

    protected void setMolecule(int n, Molecule molecule, NumberFormat numberFormat) {
        this.setMolecule(n, molecule, numberFormat, false);
    }

    protected void setMolecule(int n, Molecule molecule, NumberFormat numberFormat, boolean bl) {
        this.concentrationNodes[n].setMolecule(molecule, numberFormat, bl);
    }

    protected void setConcentration(int n, double d) {
        this.concentrationNodes[n].setConcentration(d);
    }

    protected void setVisible(int n, boolean bl) {
        this.concentrationNodes[n].setVisible(bl);
    }

    protected void setAllVisible(boolean bl) {
        for (int i = 0; i < 4; ++i) {
            this.setVisible(i, bl);
        }
    }

    protected void updateLayout() {
        int n;
        int n2 = 0;
        ConcentrationNode[] concentrationNodeArray = this.concentrationNodes;
        int n3 = concentrationNodeArray.length;
        for (n = 0; n < n3; ++n) {
            ConcentrationNode concentrationNode = concentrationNodeArray[n];
            if (!concentrationNode.getVisible()) continue;
            ++n2;
        }
        if (n2 > 0) {
            double d = (this.outlineSize.getWidth() - (double)n2 * 45.0 - (double)(n2 - 1) * 45.0) / 2.0;
            assert (d >= 0.0);
            for (n = 0; n < this.concentrationNodes.length; ++n) {
                double d2 = this.graphOutlineNode.getXOffset() + d + (double)n * 90.0 + 22.5;
                double d3 = this.outlineSize.getHeight();
                this.concentrationNodes[n].setOffset(d2, d3);
            }
        }
    }

    private static class BarNode
    extends PPath {
        private final double barWidth;
        private final Rectangle2D rectangle;

        public BarNode(double d) {
            this.barWidth = d;
            this.rectangle = new Rectangle2D.Double();
            this.setPaint(Color.BLACK);
            this.setStroke(null);
            this.setBarHeight(1.0);
        }

        public void setBarHeight(double d) {
            this.rectangle.setRect(-(this.barWidth / 2.0), -d, this.barWidth, d);
            this.setPathTo(this.rectangle);
        }
    }

    private static class ConcentrationNode
    extends PComposite {
        private final double maxBarHeight;
        private final BarNode barNode;
        private final NegligibleValueNode valueNode;
        private final PImage iconNode;
        private final HTMLNode symbolNode;

        public ConcentrationNode(double d, boolean bl, boolean bl2) {
            this.maxBarHeight = d;
            this.barNode = new BarNode(45.0);
            this.addChild(this.barNode);
            this.valueNode = new NegligibleValueNode();
            this.valueNode.rotate(-1.5707963267948966);
            this.addChild(this.valueNode);
            this.iconNode = new PImage();
            this.iconNode.setVisible(bl);
            this.addChild(this.iconNode);
            this.symbolNode = new HTMLNode();
            this.symbolNode.setFont(SYMBOL_FONT);
            this.symbolNode.setVisible(bl2);
            this.addChild(this.symbolNode);
        }

        public void setMolecule(Molecule molecule, NumberFormat numberFormat, boolean bl) {
            this.barNode.setPaint(molecule.getColor());
            this.valueNode.setFormat(numberFormat);
            this.valueNode.setNegligibleEnabled(bl, 0.0);
            this.iconNode.setImage(molecule.getImage());
            this.symbolNode.setHTML(molecule.getSymbol());
            this.updateLayout();
        }

        public void setConcentration(double d) {
            this.valueNode.setValue(d);
            this.barNode.setBarHeight(this.calculateBarHeight(d));
        }

        private double calculateBarHeight(double d) {
            double d2 = MathUtil.log10(d);
            return this.maxBarHeight * (d2 - -8.0) / 10.0;
        }

        private void updateLayout() {
            double d = 0.0;
            double d2 = 0.0;
            this.barNode.setOffset(d, d2);
            d = this.barNode.getFullBoundsReference().getCenterX() - this.valueNode.getFullBoundsReference().getWidth() / 2.0;
            d2 = this.barNode.getFullBoundsReference().getMaxY() - 10.0;
            this.valueNode.setOffset(d, d2);
            if (this.iconNode.getVisible()) {
                d = this.barNode.getFullBoundsReference().getCenterX() - this.iconNode.getFullBoundsReference().getWidth() / 2.0;
                d2 = this.barNode.getFullBoundsReference().getMaxY() + 10.0;
                this.iconNode.setOffset(d, d2);
            }
            if (this.symbolNode.getVisible()) {
                if (this.iconNode.getVisible()) {
                    d = this.iconNode.getFullBoundsReference().getCenterX() - this.symbolNode.getFullBoundsReference().getWidth() / 2.0 - PNodeLayoutUtils.getOriginXOffset(this.symbolNode);
                    d2 = this.iconNode.getFullBoundsReference().getMaxY() + 5.0;
                    this.symbolNode.setOffset(d, d2);
                } else {
                    d = this.barNode.getFullBoundsReference().getCenterX() - this.iconNode.getFullBoundsReference().getWidth() / 2.0;
                    d2 = this.barNode.getFullBoundsReference().getMaxY() + 10.0;
                    this.symbolNode.setOffset(d, d2);
                }
            }
        }
    }
}

