/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.constants.ABSImages;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.model.AcidSolution;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.Molecule;
import edu.colorado.phet.acidbasesolutions.model.PureWaterSolution;
import edu.colorado.phet.acidbasesolutions.model.ReactionEquation;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.acidbasesolutions.model.StrongAcidSolution;
import edu.colorado.phet.acidbasesolutions.model.StrongBaseSolution;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ChemicalSymbolNode;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;

public class ReactionEquationNode
extends PComposite {
    private static final Font SYMBOL_FONT = new PhetFont(20);
    private static final Color SYMBOL_COLOR = Color.BLACK;
    private static final Image TWO_H2O_IMAGE = ReactionEquationNode.create2H2OImage();
    private final ReactionEquation equation;

    public ReactionEquationNode(ReactionEquation reactionEquation) {
        this.equation = reactionEquation;
        reactionEquation.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void solutionChanged() {
                ReactionEquationNode.this.update();
            }
        });
        this.addInputEventListener(new NonInteractiveEventHandler(ABSSimSharing.UserComponents.reactionEquation));
        this.setOffset(reactionEquation.getLocationReference());
        this.update();
    }

    private void update() {
        double d;
        double d2;
        SymbolNode symbolNode;
        PImage pImage;
        SymbolNode symbolNode2;
        PImage pImage2;
        SymbolNode symbolNode3;
        PImage pImage3;
        SymbolNode symbolNode4;
        PImage pImage4;
        boolean bl;
        this.removeAllChildren();
        AqueousSolution aqueousSolution = this.equation.getSolution();
        boolean bl2 = aqueousSolution instanceof PureWaterSolution;
        boolean bl3 = aqueousSolution instanceof AcidSolution;
        boolean bl4 = bl = aqueousSolution instanceof StrongAcidSolution || aqueousSolution instanceof StrongBaseSolution;
        if (bl2) {
            pImage4 = new PImage(TWO_H2O_IMAGE);
            symbolNode4 = new SymbolNode("2" + aqueousSolution.getWaterMolecule().getSymbol());
            pImage3 = null;
            symbolNode3 = null;
            pImage2 = new PImage(aqueousSolution.getH3OMolecule().getImage());
            symbolNode2 = new SymbolNode(aqueousSolution.getH3OMolecule().getSymbol());
            pImage = new PImage(aqueousSolution.getOHMolecule().getImage());
            symbolNode = new SymbolNode(aqueousSolution.getOHMolecule().getSymbol());
        } else {
            pImage4 = new PImage(aqueousSolution.getSolute().getImage());
            symbolNode4 = new SymbolNode(aqueousSolution.getSolute().getSymbol());
            if (bl3) {
                pImage3 = new PImage(aqueousSolution.getWaterMolecule().getImage());
                symbolNode3 = new SymbolNode(aqueousSolution.getWaterMolecule().getSymbol());
                pImage2 = new PImage(aqueousSolution.getProduct().getImage());
                symbolNode2 = new SymbolNode(aqueousSolution.getProduct().getSymbol());
                pImage = new PImage(aqueousSolution.getH3OMolecule().getImage());
                symbolNode = new SymbolNode(aqueousSolution.getH3OMolecule().getSymbol());
            } else {
                pImage3 = bl ? null : new PImage(aqueousSolution.getWaterMolecule().getImage());
                symbolNode3 = bl ? null : new SymbolNode(aqueousSolution.getWaterMolecule().getSymbol());
                pImage2 = new PImage(aqueousSolution.getProduct().getImage());
                symbolNode2 = new SymbolNode(aqueousSolution.getProduct().getSymbol());
                pImage = new PImage(aqueousSolution.getOHMolecule().getImage());
                symbolNode = new SymbolNode(aqueousSolution.getOHMolecule().getSymbol());
            }
        }
        ArrowNode arrowNode = new ArrowNode(bl);
        PlusNode plusNode = new PlusNode();
        PlusNode plusNode2 = new PlusNode();
        PComposite pComposite = new PComposite();
        this.addChild(pComposite);
        pComposite.addChild(pImage4);
        pComposite.addChild(symbolNode4);
        if (symbolNode3 != null) {
            pComposite.addChild(plusNode);
            pComposite.addChild(pImage3);
            pComposite.addChild(symbolNode3);
        }
        pComposite.addChild(arrowNode);
        pComposite.addChild(pImage2);
        pComposite.addChild(symbolNode2);
        pComposite.addChild(plusNode2);
        pComposite.addChild(pImage);
        pComposite.addChild(symbolNode);
        ReactionEquationNode.layoutSymbolAndImage(symbolNode4, pImage4, 0.0);
        SymbolNode symbolNode5 = symbolNode4;
        if (symbolNode3 != null) {
            d2 = symbolNode4.getFullBoundsReference().getMaxX() + 15.0;
            d = symbolNode4.getYOffset() - symbolNode4.getCapHeight() / 2.0 - plusNode.getFullBoundsReference().getHeight() / 2.0;
            plusNode.setOffset(d2, d);
            ReactionEquationNode.layoutSymbolAndImage(symbolNode3, pImage3, plusNode.getFullBoundsReference().getMaxX() + 15.0);
            symbolNode5 = symbolNode3;
        }
        d2 = symbolNode5.getFullBoundsReference().getMaxX() + 15.0;
        d = symbolNode5.getYOffset() - symbolNode5.getCapHeight() / 2.0 - arrowNode.getFullBoundsReference().getHeight() / 2.0;
        arrowNode.setOffset(d2, d);
        ReactionEquationNode.layoutSymbolAndImage(symbolNode2, pImage2, arrowNode.getFullBoundsReference().getMaxX() + 15.0);
        d2 = symbolNode2.getFullBoundsReference().getMaxX() + 15.0;
        d = symbolNode2.getYOffset() - symbolNode2.getCapHeight() / 2.0 - plusNode2.getFullBoundsReference().getHeight() / 2.0;
        plusNode2.setOffset(d2, d);
        ReactionEquationNode.layoutSymbolAndImage(symbolNode, pImage, plusNode2.getFullBoundsReference().getMaxX() + 15.0);
        d2 = -pComposite.getFullBoundsReference().getWidth() / 2.0;
        d = -PNodeLayoutUtils.getOriginYOffset(pComposite);
        pComposite.setOffset(d2, d);
    }

    private static void layoutSymbolAndImage(SymbolNode symbolNode, PImage pImage, double d) {
        double d2 = d;
        double d3 = 0.0;
        symbolNode.setOffset(d2, d3);
        d2 = symbolNode.getFullBoundsReference().getCenterX() - pImage.getFullBoundsReference().getWidth() / 2.0;
        d3 = symbolNode.getYOffset() - symbolNode.getCapHeight() - 10.0 - pImage.getFullBoundsReference().getHeight();
        pImage.setOffset(d2, d3);
    }

    private static Image create2H2OImage() {
        Molecule.WaterMolecule waterMolecule = new Molecule.WaterMolecule();
        PImage pImage = new PImage(waterMolecule.getImage());
        PImage pImage2 = new PImage(waterMolecule.getImage());
        PComposite pComposite = new PComposite();
        pComposite.addChild(pImage);
        pComposite.addChild(pImage2);
        pImage.setOffset(0.0, 0.0);
        pImage2.setOffset(pImage.getFullBoundsReference().getMaxX() + 2.0, pImage.getYOffset());
        return pComposite.toImage();
    }

    private static class ArrowNode
    extends PImage {
        public ArrowNode(boolean bl) {
            super(bl ? ABSImages.ARROW_SINGLE : ABSImages.ARROW_DOUBLE);
        }
    }

    private static class PlusNode
    extends PText {
        public PlusNode() {
            super("+");
            this.setFont(SYMBOL_FONT);
        }
    }

    private static class SymbolNode
    extends ChemicalSymbolNode {
        public SymbolNode(String string) {
            super(string, SYMBOL_FONT, SYMBOL_COLOR);
        }
    }
}

