/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.model.PHPaper;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PHPaperNode
extends PhetPNode {
    private static final Stroke STROKE = new BasicStroke(0.5f);
    private static final Color STROKE_COLOR = new Color(150, 150, 150);
    private PHPaper paper;
    private PPath paperBodyNode;
    private PPath dippedPathNode;
    private Rectangle2D dippedRectangle;

    public PHPaperNode(final PHPaper pHPaper) {
        this.paper = pHPaper;
        pHPaper.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void locationChanged() {
                PHPaperNode.this.setOffset(pHPaper.getLocationReference());
            }

            public void visibilityChanged() {
                PHPaperNode.this.setVisible(pHPaper.isVisible());
            }
        });
        pHPaper.addPHPaperChangeListener(new PHPaper.PHPaperChangeListener(){

            public void dippedColorChanged() {
                PHPaperNode.this.updateColor();
            }

            public void dippedHeightChanged() {
                PHPaperNode.this.updateGeometry();
                PHPaperNode.this.updateColor();
            }
        });
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PhPaperDragHandler(pHPaper, this));
        Rectangle2D.Double double_ = new Rectangle2D.Double(-pHPaper.getWidth() / 2.0, 0.0, pHPaper.getWidth(), pHPaper.getHeight());
        this.paperBodyNode = new PPath(double_);
        this.paperBodyNode.setStroke(null);
        this.paperBodyNode.setPaint(pHPaper.getPaperColor());
        this.addChild(this.paperBodyNode);
        this.dippedRectangle = new Rectangle2D.Double();
        this.dippedPathNode = new PPath();
        this.dippedPathNode.setStroke(null);
        this.dippedPathNode.setPaint(pHPaper.getDippedColor());
        this.addChild(this.dippedPathNode);
        PPath pPath = new PPath(double_);
        pPath.setStroke(STROKE);
        pPath.setStrokePaint(STROKE_COLOR);
        this.addChild(pPath);
        this.setOffset(pHPaper.getLocationReference());
        this.setVisible(pHPaper.isVisible());
        this.updateGeometry();
        this.updateColor();
    }

    private void updateGeometry() {
        double d = -this.paper.getWidth() / 2.0;
        double d2 = this.paper.getHeight() - this.paper.getDippedHeight();
        this.dippedRectangle.setRect(d, d2, this.paper.getWidth(), this.paper.getDippedHeight());
        this.dippedPathNode.setPathTo(this.dippedRectangle);
    }

    private void updateColor() {
        this.dippedPathNode.setPaint(this.paper.getDippedColor());
    }

    private static class PhPaperDragHandler
    extends SimSharingDragHandler {
        private final PHPaper paper;
        private final PNode dragNode;
        private double clickXOffset;
        private double clickYOffset;

        public PhPaperDragHandler(PHPaper pHPaper, PNode pNode) {
            super(ABSSimSharing.UserComponents.phPaper, UserComponentTypes.sprite);
            this.paper = pHPaper;
            this.dragNode = pNode;
        }

        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
            this.clickXOffset = point2D.getX() - this.paper.getLocationReference().getX();
            this.clickYOffset = point2D.getY() - this.paper.getLocationReference().getY();
        }

        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            boolean bl = this.paper.isInSolution();
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
            double d = point2D.getX() - this.clickXOffset;
            double d2 = point2D.getY() - this.clickYOffset;
            this.paper.setLocation(d, d2);
            if (bl != this.paper.isInSolution()) {
                SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.sprite, UserActions.drag, ParameterSet.parameterSet((IParameterKey)ABSSimSharing.ParameterKeys.isInSolution, this.paper.isInSolution()));
            }
        }
    }
}

