/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.model.PHMeter;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.acidbasesolutions.view.PHValue;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class PHMeterNode
extends PhetPNode {
    private static final Color SHAFT_COLOR = Color.LIGHT_GRAY;
    private static final Color SHAFT_STROKE_COLOR = Color.BLACK;
    private static final Stroke SHAFT_STROKE = new BasicStroke(0.25f);
    private static final Color TIP_COLOR = Color.BLACK;
    private static final Color DISPLAY_BORDER_COLOR = Color.DARK_GRAY;
    private static final Font DISPLAY_FONT = new PhetFont(1, 24);
    private static final DecimalFormat DISPLAY_FORMAT = new DecimalFormat("#0.00");
    private static final Color DISPLAY_BACKGROUND = Color.LIGHT_GRAY;
    private PHMeter meter;
    private final DisplayNode displayNode = new DisplayNode();

    public PHMeterNode(final PHMeter pHMeter) {
        this(pHMeter.getShaftSizeReference(), pHMeter.getTipSizeRefernence());
        this.meter = pHMeter;
        pHMeter.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeListener(){

            public void solutionChanged() {
                PHMeterNode.this.updateDisplay();
            }

            public void strengthChanged() {
                PHMeterNode.this.updateDisplay();
            }

            public void concentrationChanged() {
                PHMeterNode.this.updateDisplay();
            }

            public void locationChanged() {
                PHMeterNode.this.setOffset(pHMeter.getLocationReference());
                PHMeterNode.this.updateDisplay();
            }

            public void visibilityChanged() {
                PHMeterNode.this.setVisible(pHMeter.isVisible());
            }
        });
        this.addInputEventListener(new CursorHandler(8));
        this.addInputEventListener(new PhMeterDragHandler(pHMeter, this));
        this.setOffset(pHMeter.getLocationReference());
        this.setVisible(pHMeter.isVisible());
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.displayNode.setValue(this.meter.getValue());
    }

    private PHMeterNode(PDimension pDimension, PDimension pDimension2) {
        TipNode tipNode = new TipNode(pDimension2);
        double d = 0.05 * pDimension2.getHeight();
        ShaftNode shaftNode = new ShaftNode(pDimension.width, pDimension.height + 2.0 * d);
        this.addChild(shaftNode);
        this.addChild(tipNode);
        this.addChild(this.displayNode);
        double d2 = -tipNode.getFullBoundsReference().getWidth() / 2.0;
        double d3 = -tipNode.getFullBoundsReference().getHeight();
        tipNode.setOffset(d2, d3);
        d2 = -shaftNode.getFullBoundsReference().getWidth() / 2.0;
        d3 = tipNode.getFullBoundsReference().getMinY() - shaftNode.getFullBoundsReference().getHeight() + d;
        shaftNode.setOffset(d2, d3);
        d2 = -0.15 * this.displayNode.getFullBoundsReference().getWidth();
        d3 = shaftNode.getFullBoundsReference().getMinY() - this.displayNode.getFullBoundsReference().getHeight() + d;
        this.displayNode.setOffset(d2, d3);
    }

    private static class DisplayNode
    extends PComposite {
        private PText valueNode = new PText();

        public DisplayNode() {
            this.valueNode.setFont(DISPLAY_FONT);
            this.setValue(new Double(15.0));
            PComposite pComposite = new PComposite();
            pComposite.addChild(this.valueNode);
            this.valueNode.setOffset(0.0, 0.0);
            PBounds pBounds = pComposite.getFullBoundsReference();
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, pBounds.getWidth() + 24.0, pBounds.getHeight() + 24.0, 10.0, 10.0);
            PPath pPath = new PPath(double_);
            this.addChild(pPath);
            pPath.setPaint(DISPLAY_BACKGROUND);
            pPath.setStroke(new BasicStroke(3.0f));
            pPath.setStrokePaint(DISPLAY_BORDER_COLOR);
            pPath.addChild(pComposite);
            pComposite.setOffset(12.0, 12.0);
        }

        public void setValue(Double d) {
            String string = null;
            if (d != null) {
                PHValue pHValue = new PHValue(d);
                string = MessageFormat.format(ABSStrings.PATTERN_LABEL_VALUE, ABSStrings.PH, DISPLAY_FORMAT.format(pHValue.getValue()));
            } else {
                string = MessageFormat.format(ABSStrings.PATTERN_LABEL_VALUE, ABSStrings.PH, "");
            }
            this.valueNode.setText(string);
        }
    }

    private static class PhMeterDragHandler
    extends SimSharingDragHandler {
        private final PHMeter meter;
        private final PNode dragNode;
        private double clickYOffset;

        public PhMeterDragHandler(PHMeter pHMeter, PNode pNode) {
            super(ABSSimSharing.UserComponents.phMeter, UserComponentTypes.sprite);
            this.meter = pHMeter;
            this.dragNode = pNode;
        }

        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
            this.clickYOffset = point2D.getY() - this.meter.getLocationReference().getY();
        }

        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            boolean bl = this.meter.isInSolution();
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
            double d = point2D.getY() - this.clickYOffset;
            this.meter.setLocation(this.meter.getLocationReference().getX(), d);
            if (bl != this.meter.isInSolution()) {
                SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.sprite, UserActions.drag, ParameterSet.parameterSet((IParameterKey)ABSSimSharing.ParameterKeys.isInSolution, this.meter.isInSolution()));
            }
        }
    }

    private static class ShaftNode
    extends PPath {
        public ShaftNode(double d, double d2) {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
            this.setPaint(SHAFT_COLOR);
            this.setStroke(SHAFT_STROKE);
            this.setStrokePaint(SHAFT_STROKE_COLOR);
        }
    }

    private static class TipNode
    extends PPath {
        public TipNode(PDimension pDimension) {
            this((float)pDimension.width, (float)pDimension.height);
        }

        public TipNode(float f, float f2) {
            float f3 = 0.6f * f2;
            float f4 = f2 - f3;
            float f5 = 0.4f * f;
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 0.0f, f, f3, f5, f5);
            Rectangle2D.Float float_2 = new Rectangle2D.Float(0.0f, f3 / 2.0f, f, f3 / 2.0f);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, f2 - f4);
            generalPath.lineTo(f / 2.0f, f2);
            generalPath.lineTo(f, f2 - f4);
            generalPath.closePath();
            Area area = new Area(float_);
            area.add(new Area(float_2));
            area.add(new Area(generalPath));
            this.setPathTo(area);
            this.setPaint(TIP_COLOR);
            this.setStroke(null);
        }
    }
}

