/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.constants.ABSStrings;
import edu.colorado.phet.acidbasesolutions.model.PHPaper;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class PHColorKeyNode
extends PhetPNode {
    private static final Color TITLE_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(18);
    private static final PDimension COLOR_CHIP_SIZE = new PDimension(23.0, 50.0);
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Font LABEL_FONT = new PhetFont(13);

    public PHColorKeyNode(final PHPaper pHPaper) {
        pHPaper.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void visibilityChanged() {
                PHColorKeyNode.this.setVisible(pHPaper.isVisible());
            }
        });
        PText pText = new PText(ABSStrings.PH_COLOR_KEY);
        pText.setTextPaint(TITLE_COLOR);
        pText.setFont(TITLE_FONT);
        this.addChild(pText);
        double d = 0.0;
        double d2 = pText.getFullBoundsReference().getMaxY() + 4.0;
        for (int i = 0; i <= 14; ++i) {
            PHColorNode pHColorNode = new PHColorNode(pHPaper, i);
            this.addChild(pHColorNode);
            pHColorNode.setOffset(d, d2);
            d += COLOR_CHIP_SIZE.getWidth() + 2.0;
        }
        this.setVisible(pHPaper.isVisible());
        this.addInputEventListener(new NonInteractiveEventHandler(ABSSimSharing.UserComponents.phColorKey));
    }

    private static class ColorChipNode
    extends PPath {
        public ColorChipNode(Color color) {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, COLOR_CHIP_SIZE.getWidth(), COLOR_CHIP_SIZE.getHeight()));
            this.setPaint(color);
            this.setStroke(null);
        }
    }

    private static class LabelNode
    extends PText {
        public LabelNode(int n) {
            super(String.valueOf(n));
            this.setTextPaint(LABEL_COLOR);
            this.setFont(LABEL_FONT);
        }
    }

    private static class PHColorNode
    extends PComposite {
        public PHColorNode(PHPaper pHPaper, int n) {
            ColorChipNode colorChipNode = new ColorChipNode(pHPaper.createColor(n));
            this.addChild(colorChipNode);
            LabelNode labelNode = new LabelNode(n);
            this.addChild(labelNode);
            double d = colorChipNode.getFullBoundsReference().getCenterX() - labelNode.getFullBoundsReference().getWidth() / 2.0;
            double d2 = colorChipNode.getFullBoundsReference().getMaxY() + 1.0;
            labelNode.setOffset(d, d2);
        }
    }
}

