/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.model.AcidSolution;
import edu.colorado.phet.acidbasesolutions.model.AqueousSolution;
import edu.colorado.phet.acidbasesolutions.model.BaseSolution;
import edu.colorado.phet.acidbasesolutions.model.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.model.Molecule;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.acidbasesolutions.view.IMoleculeCountStrategy;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.Point2D;

class MoleculesNode
extends PComposite {
    private final MagnifyingGlass magnifyingGlass;
    private final MoleculeImageParentNode parentReactant;
    private final MoleculeImageParentNode parentProduct;
    private final MoleculeImageParentNode parentH3O;
    private final MoleculeImageParentNode parentOH;
    private final MoleculeImageParentNode parentH2O;
    private final IMoleculeCountStrategy moleculeCountStrategy;
    private final IMoleculeCountStrategy h2oCountStrategy;

    public MoleculesNode(final MagnifyingGlass magnifyingGlass) {
        this.setPickable(false);
        this.moleculeCountStrategy = new IMoleculeCountStrategy.ConcentrationMoleculeCountStrategy();
        this.h2oCountStrategy = new IMoleculeCountStrategy.ConstantMoleculeCountStrategy();
        this.magnifyingGlass = magnifyingGlass;
        magnifyingGlass.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void solutionChanged() {
                MoleculesNode.this.deleteAllMolecules();
                MoleculesNode.this.updateMolecules();
                MoleculesNode.this.updateMinoritySpeciesVisibility();
            }

            public void strengthChanged() {
                MoleculesNode.this.updateMolecules();
            }

            public void concentrationChanged() {
                MoleculesNode.this.updateMolecules();
            }
        });
        magnifyingGlass.addMagnifyingGlassListener(new MagnifyingGlass.MagnifyingGlassChangeListener(){

            public void waterVisibleChanged() {
                MoleculesNode.this.setWaterVisible(magnifyingGlass.isWaterVisible());
            }
        });
        this.parentReactant = new MoleculeImageParentNode();
        this.parentProduct = new MoleculeImageParentNode();
        this.parentH3O = new MoleculeImageParentNode();
        this.parentOH = new MoleculeImageParentNode();
        this.parentH2O = new MoleculeImageParentNode();
        this.addChild(this.parentH2O);
        this.addChild(this.parentReactant);
        this.addChild(this.parentProduct);
        this.addChild(this.parentH3O);
        this.addChild(this.parentOH);
        this.parentH2O.setVisible(magnifyingGlass.isWaterVisible());
        this.updateMolecules();
        this.updateMinoritySpeciesVisibility();
    }

    private void setWaterVisible(boolean bl) {
        if (bl != this.isWaterVisible()) {
            this.parentH2O.setVisible(bl);
        }
    }

    private boolean isWaterVisible() {
        return this.parentH2O.getVisible();
    }

    private void updateMinoritySpeciesVisibility() {
        AqueousSolution aqueousSolution = this.magnifyingGlass.getSolution();
        this.parentOH.setVisible(!(aqueousSolution instanceof AcidSolution));
        this.parentH3O.setVisible(!(aqueousSolution instanceof BaseSolution));
    }

    private void updateMolecules() {
        AqueousSolution aqueousSolution = this.magnifyingGlass.getSolution();
        int n = this.moleculeCountStrategy.getNumberOfMolecules(aqueousSolution.getSoluteConcentration(), 200);
        int n2 = this.moleculeCountStrategy.getNumberOfMolecules(aqueousSolution.getProductConcentration(), 200);
        int n3 = this.moleculeCountStrategy.getNumberOfMolecules(aqueousSolution.getH3OConcentration(), 200);
        int n4 = this.moleculeCountStrategy.getNumberOfMolecules(aqueousSolution.getOHConcentration(), 200);
        int n5 = this.h2oCountStrategy.getNumberOfMolecules(aqueousSolution.getH2OConcentration(), 2000);
        this.updateMoleculeNodes(this.parentReactant, aqueousSolution.getSolute(), n);
        this.updateMoleculeNodes(this.parentProduct, aqueousSolution.getProduct(), n2);
        this.updateMoleculeNodes(this.parentH3O, aqueousSolution.getH3OMolecule(), n3);
        this.updateMoleculeNodes(this.parentOH, aqueousSolution.getOHMolecule(), n4);
        this.updateMoleculeNodes(this.parentH2O, aqueousSolution.getWaterMolecule(), n5);
    }

    private void updateMoleculeNodes(PNode pNode, Molecule molecule, int n) {
        while (n < pNode.getChildrenCount() && n >= 0) {
            pNode.removeChild(pNode.getChildrenCount() - 1);
        }
        while (n > pNode.getChildrenCount()) {
            PImage pImage = new PImage(molecule.getImage());
            pImage.setScale(1.0);
            pNode.addChild(pImage);
            Point2D point2D = this.getRandomPoint();
            double d = point2D.getX() - pImage.getFullBoundsReference().getWidth() / 2.0;
            double d2 = point2D.getY() - pImage.getFullBoundsReference().getHeight() / 2.0;
            pImage.setOffset(d, d2);
        }
        assert (n == pNode.getChildrenCount());
    }

    private void deleteAllMolecules() {
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            PNode pNode = this.getChild(i);
            if (!(pNode instanceof MoleculeImageParentNode)) continue;
            pNode.removeAllChildren();
        }
    }

    protected Point2D getRandomPoint() {
        double d = this.magnifyingGlass.getDiameter() / 2.0;
        double d2 = d * Math.sqrt(Math.random());
        double d3 = Math.random() * 2.0 * Math.PI;
        double d4 = d2 * Math.cos(d3);
        double d5 = d2 * Math.sin(d3);
        return new Point2D.Double(d4, d5);
    }

    protected static class MoleculeImageParentNode
    extends PComposite {
        protected MoleculeImageParentNode() {
        }
    }
}

