/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.acidbasesolutions.view;

import edu.colorado.phet.acidbasesolutions.constants.ABSColors;
import edu.colorado.phet.acidbasesolutions.constants.ABSSimSharing;
import edu.colorado.phet.acidbasesolutions.model.MagnifyingGlass;
import edu.colorado.phet.acidbasesolutions.model.SolutionRepresentation;
import edu.colorado.phet.acidbasesolutions.view.MoleculesNode;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;

public class MagnifyingGlassNode
extends PhetPNode {
    private static final Stroke GLASS_STROKE = new BasicStroke(18.0f);
    private static final Color GLASS_STROKE_COLOR = Color.BLACK;
    private static final Stroke HANDLE_STROKE = new BasicStroke(2.0f);
    private static final Color HANDLE_STROKE_COLOR = Color.BLACK;
    private static final Color HANDLE_FILL_COLOR = new Color(85, 55, 33);
    private final MagnifyingGlass magnifyingGlass;
    private final PPath handleNode;
    private final RoundRectangle2D handlePath;
    private final PPath rimNode;
    private final PPath lensNode;
    private final Ellipse2D rimPath;
    private final MoleculesNode moleculesNode;

    public MagnifyingGlassNode(final MagnifyingGlass magnifyingGlass) {
        this.magnifyingGlass = magnifyingGlass;
        magnifyingGlass.addSolutionRepresentationChangeListener(new SolutionRepresentation.SolutionRepresentationChangeAdapter(){

            public void solutionChanged() {
                MagnifyingGlassNode.this.updateColor();
            }

            public void visibilityChanged() {
                MagnifyingGlassNode.this.setVisible(magnifyingGlass.isVisible());
            }
        });
        this.handlePath = new RoundRectangle2D.Double();
        this.handleNode = new PPath();
        this.handleNode.setStroke(HANDLE_STROKE);
        this.handleNode.setStrokePaint(HANDLE_STROKE_COLOR);
        this.handleNode.setPaint(HANDLE_FILL_COLOR);
        this.rimPath = new Ellipse2D.Double();
        this.rimNode = new PClip();
        this.rimNode.setStroke(GLASS_STROKE);
        this.rimNode.setStrokePaint(GLASS_STROKE_COLOR);
        this.rimNode.setPaint(null);
        this.lensNode = new PPath();
        this.lensNode.setPaint(ABSColors.CANVAS_BACKGROUND);
        this.moleculesNode = new MoleculesNode(magnifyingGlass);
        this.addChild(this.handleNode);
        this.addChild(this.lensNode);
        this.addChild(this.rimNode);
        this.rimNode.addChild(this.moleculesNode);
        this.updateGeometry();
        this.updateColor();
        this.setOffset(magnifyingGlass.getLocationReference());
        this.setVisible(magnifyingGlass.isVisible());
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                ABSSimSharing.ParameterKeys parameterKeys = pInputEvent.getPickedNode() == MagnifyingGlassNode.this.handleNode ? ABSSimSharing.ParameterKeys.handle : (pInputEvent.getPickedNode() == MagnifyingGlassNode.this.moleculesNode ? ABSSimSharing.ParameterKeys.molecule : ABSSimSharing.ParameterKeys.lens);
                SimSharingManager.sendUserMessage(ABSSimSharing.UserComponents.magnifyingGlass, UserComponentTypes.sprite, UserActions.pressed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.interactive, false).with((IParameterKey)ParameterKeys.part, parameterKeys.toString()));
            }
        });
    }

    private void updateGeometry() {
        double d = this.magnifyingGlass.getDiameter();
        this.rimPath.setFrame(-d / 2.0, -d / 2.0, d, d);
        this.rimNode.setPathTo(this.rimPath);
        this.lensNode.setPathTo(this.rimPath);
        double d2 = d / 8.0;
        double d3 = d / 2.25;
        this.handlePath.setRoundRect(-d2 / 2.0, 0.0, d2, d3, 40.0, 40.0);
        this.handleNode.setPathTo(this.handlePath);
        this.handleNode.getTransform().setToIdentity();
        PAffineTransform pAffineTransform = new PAffineTransform();
        pAffineTransform.rotate(-1.0471975511965976);
        pAffineTransform.translate(0.0, d / 2.0);
        this.handleNode.setTransform(pAffineTransform);
    }

    private void updateColor() {
        this.rimNode.setPaint(this.magnifyingGlass.getSolution().getColor());
    }
}

